/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.rule.ws.internal.schema;

import java.util.HashMap;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.description.AxisService;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.wso2.carbon.rule.common.Fact;
import org.wso2.carbon.rule.common.Input;
import org.wso2.carbon.rule.common.Operation;
import org.wso2.carbon.rule.common.Output;
import org.wso2.carbon.rule.common.exception.RuleConfigurationException;
import org.wso2.carbon.rule.ws.internal.schema.RuleSchemaGenerator;

public class SchemaBuilder {
    private RuleSchemaGenerator ruleSchemaGenerator;

    public SchemaBuilder(ClassLoader classLoader, AxisService axisService) throws RuleConfigurationException {
        try {
            this.ruleSchemaGenerator = new RuleSchemaGenerator(classLoader, axisService);
            this.ruleSchemaGenerator.setPkg2nsmap(new HashMap());
        }
        catch (Exception e) {
            throw new RuleConfigurationException("Problem with creating the schema generator");
        }
    }

    public void addOperation(Operation operation) throws RuleConfigurationException {
        Input input = operation.getInput();
        this.generateOperationElement(input.getNameSpace(), input.getWrapperElementName(), input.getFacts());
        Output output = operation.getOutput();
        this.generateOperationElement(output.getNameSpace(), output.getWrapperElementName(), output.getFacts());
    }

    private void generateOperationElement(String namespace, String wrapperElementName, List<Fact> facts) throws RuleConfigurationException {
        XmlSchema xmlSchema = this.ruleSchemaGenerator.getXmlSchema(namespace);
        XmlSchemaElement xmlSchemaElement = new XmlSchemaElement();
        xmlSchemaElement.setName(wrapperElementName);
        xmlSchemaElement.setQName(new QName(namespace, wrapperElementName));
        XmlSchemaComplexType xmlSchemaComplexType = new XmlSchemaComplexType(xmlSchema);
        xmlSchemaElement.setSchemaType((XmlSchemaType)xmlSchemaComplexType);
        XmlSchemaSequence xmlSchemaSequence = new XmlSchemaSequence();
        xmlSchemaComplexType.setParticle((XmlSchemaParticle)xmlSchemaSequence);
        XmlSchemaElement factElement = null;
        for (Fact fact : facts) {
            factElement = new XmlSchemaElement();
            factElement.setName(fact.getElementName());
            factElement.setMinOccurs(0L);
            factElement.setMaxOccurs(Long.MAX_VALUE);
            xmlSchemaSequence.getItems().add((XmlSchemaObject)factElement);
            try {
                Class factClass = fact.getTypeClass();
                this.ruleSchemaGenerator.getPkg2nsmap().put(factClass.getPackage().getName(), fact.getNamespace());
                QName complexTypeName = this.ruleSchemaGenerator.generateSchema(factClass);
                factElement.setSchemaTypeName(complexTypeName);
            }
            catch (ClassNotFoundException e) {
                throw new RuleConfigurationException(" Can not find the class " + fact.getType(), (Throwable)e);
            }
            catch (Exception e) {
                throw new RuleConfigurationException(" Can not generate the schema for " + fact.getType(), (Throwable)e);
            }
        }
        xmlSchema.getItems().add((XmlSchemaObject)xmlSchemaElement);
        xmlSchema.getElements().add(new QName(namespace, wrapperElementName), (XmlSchemaObject)xmlSchemaElement);
    }

    public List<XmlSchema> getSchemaList() {
        return this.ruleSchemaGenerator.getSchemaList();
    }
}

