/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.callhome;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Logger;
import javax.net.ssl.HttpsURLConnection;
import org.wso2.callhome.exception.CallHomeException;
import org.wso2.callhome.utils.ExtractedInfo;
import org.yaml.snakeyaml.Yaml;

class CallHome {
    private static final Logger logger = Logger.getLogger(CallHome.class.getName());
    private static final String OS_NAME = "os.name";
    private static final String CALL_HOME_ENDPOINT = "https://api.updates.wso2.com/call-home/v1.0.0/check-updates";
    private static final String ACCESS_TOKEN = "45ffddfa-281c-36df-9fd0-d806c3f607ca";
    private static final int RETRY_DELAY = 10000;
    private static final int HTTP_CONNECTION_TIMEOUT = 10000;

    CallHome() {
    }

    void execute() {
        try {
            String productNameAndVersion = this.getProductNameAndVersion();
            long updateLevel = this.getUpdateLevel();
            String channel = this.getChannelFromConfigYaml();
            String operatingSystem = this.getOSDetails();
            String productName = this.extractProductName(productNameAndVersion);
            String productVersion = this.extractProductVersion(productNameAndVersion);
            ExtractedInfo extractedInfo = new ExtractedInfo();
            extractedInfo.setChannel(channel);
            extractedInfo.setProductName(productName);
            extractedInfo.setProductVersion(productVersion);
            extractedInfo.setOperatingSystem(operatingSystem);
            extractedInfo.setUpdateLevel(updateLevel);
            String updateInfo = this.retrieveUpdateInfoFromServer(extractedInfo);
            this.printUpdateInfo(updateInfo);
        }
        catch (CallHomeException e) {
            logger.warning("Failed to get the number of updates available.");
            logger.fine(e.toString());
        }
    }

    private String getProductHome() throws CallHomeException {
        try {
            return new File(CallHome.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getParent();
        }
        catch (URISyntaxException e) {
            logger.fine("Cannot find product path " + e.getMessage());
            throw new CallHomeException("Cannot find product path", e);
        }
    }

    private int getLastIndexOfHyphen(String productDetails) {
        return productDetails.lastIndexOf(45);
    }

    private String extractProductName(String productNameAndVersion) {
        return productNameAndVersion.substring(0, this.getLastIndexOfHyphen(productNameAndVersion));
    }

    private String extractProductVersion(String productNameAndVersion) {
        return productNameAndVersion.substring(this.getLastIndexOfHyphen(productNameAndVersion) + 1);
    }

    private Map readYaml(String yamlPath) throws FileNotFoundException {
        Yaml yaml = new Yaml();
        Map configs = Collections.emptyMap();
        if (Files.exists(Paths.get(yamlPath, new String[0]), new LinkOption[0])) {
            FileInputStream inputStream = new FileInputStream(yamlPath);
            InputStreamReader fileReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
            configs = (Map)yaml.load(fileReader);
        }
        return configs;
    }

    private String getChannelFromConfigYaml() throws CallHomeException {
        String channel = "";
        String configPath = Paths.get(this.getProductHome(), "updates", "config.yaml").toString();
        try {
            Map configs = this.readYaml(configPath);
            if (configs.containsKey("channel")) {
                channel = (String)configs.get("channel");
            }
        }
        catch (FileNotFoundException e) {
            logger.fine("Config yaml not found " + e.toString());
        }
        return channel;
    }

    private String getProductNameAndVersion() throws CallHomeException {
        byte[] productTxtContent;
        Path productTxtPath = Paths.get(this.getProductHome(), "updates", "product.txt");
        if (!Files.exists(productTxtPath, new LinkOption[0])) {
            logger.fine("Unable to find the product.txt file");
            throw new CallHomeException("Unable to find the product.txt file " + productTxtPath.toString());
        }
        try {
            productTxtContent = Files.readAllBytes(productTxtPath);
        }
        catch (IOException e) {
            logger.fine("Unable to read the product.txt content");
            throw new CallHomeException("Unable to read the product.txt content", e);
        }
        return new String(productTxtContent, StandardCharsets.UTF_8).trim();
    }

    private String getOSDetails() {
        return System.getProperty(OS_NAME);
    }

    private long getUpdateLevel() throws CallHomeException {
        File updatesDirectory = Paths.get(this.getProductHome(), "updates", "wum").toFile();
        File[] listOfFiles = updatesDirectory.listFiles();
        long lastUpdateLevel = 0L;
        if (listOfFiles != null) {
            lastUpdateLevel = this.getLastUpdateLevel(listOfFiles);
        }
        return lastUpdateLevel;
    }

    private long getLastUpdateLevel(File[] listOfFiles) {
        long lastUpdateLevel = 0L;
        for (File listOfFile : listOfFiles) {
            if (!listOfFile.isFile() || Long.parseLong(listOfFile.getName()) <= lastUpdateLevel) continue;
            lastUpdateLevel = Long.parseLong(listOfFile.getName());
        }
        return lastUpdateLevel;
    }

    private URL constructCallHomeURL(ExtractedInfo extractedInfo) throws CallHomeException {
        String productName = extractedInfo.getProductName();
        String productVersion = extractedInfo.getProductVersion();
        String operatingSystem = extractedInfo.getOperatingSystem();
        String channel = extractedInfo.getChannel();
        long updateLevel = extractedInfo.getUpdateLevel();
        try {
            return new URL("https://api.updates.wso2.com/call-home/v1.0.0/check-updates?product-name=" + productName + "&product-version=" + productVersion + "&operating-system=" + operatingSystem + "&updates-level=" + updateLevel + "&channel=" + channel);
        }
        catch (MalformedURLException e) {
            logger.fine("Error while creating URL for the CallHome endpoint " + e.getMessage());
            throw new CallHomeException("Error while creating URL for the CallHome endpoint", e);
        }
    }

    private HttpsURLConnection createHttpsURLConnection(URL url) throws IOException {
        HttpsURLConnection connection = (HttpsURLConnection)url.openConnection();
        connection.setRequestProperty("Content-Type", "application/json");
        connection.setRequestProperty("Accept", "application/json");
        connection.setRequestProperty("Authorization", "Bearer 45ffddfa-281c-36df-9fd0-d806c3f607ca");
        connection.setRequestMethod("GET");
        connection.setConnectTimeout(10000);
        return connection;
    }

    private String getResponse(HttpsURLConnection httpsURLConnection) throws CallHomeException {
        StringBuilder response;
        block27: {
            response = new StringBuilder();
            try {
                int responseCode = httpsURLConnection.getResponseCode();
                if (responseCode != 200) break block27;
                try (InputStreamReader inputStreamReader = new InputStreamReader(httpsURLConnection.getInputStream(), StandardCharsets.UTF_8);
                     BufferedReader bufferedReader = new BufferedReader(inputStreamReader);){
                    String readLine;
                    while ((readLine = bufferedReader.readLine()) != null) {
                        response.append(readLine);
                    }
                }
            }
            catch (IOException e) {
                logger.fine("Error while setting request method " + e.getMessage());
                throw new CallHomeException("Error while setting request method", e);
            }
        }
        return response.toString();
    }

    private String retrieveUpdateInfoFromServer(ExtractedInfo extractedInfo) throws CallHomeException {
        URL url = this.constructCallHomeURL(extractedInfo);
        for (int attempt = 0; attempt < 3; ++attempt) {
            try {
                HttpsURLConnection connection = this.createHttpsURLConnection(url);
                switch (connection.getResponseCode()) {
                    case 200: {
                        logger.fine(url + " OK");
                        return this.getResponse(connection);
                    }
                    case 504: {
                        logger.fine(url + " Gateway timeout");
                        break;
                    }
                    case 503: {
                        logger.fine(url + " Unavailable");
                        break;
                    }
                    default: {
                        logger.fine(url + " Unknown response code");
                        break;
                    }
                }
            }
            catch (IOException e) {
                logger.fine("Error while connecting to update server " + e.getMessage());
            }
            try {
                Thread.sleep(10000L);
                continue;
            }
            catch (InterruptedException e) {
                logger.fine("Error while trying to apply the retry delay");
            }
        }
        throw new CallHomeException("Enable to retrieve updates information from server");
    }

    private void printUpdateInfo(String msg) {
        logger.info(msg);
    }
}

