/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.management.ManagementPermission;
import java.lang.reflect.Field;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.utils.Constants;

public class Utils {
    private static final Pattern varPattern = Pattern.compile("\\$\\{([^}]*)}");
    private static final Logger logger = LoggerFactory.getLogger(Utils.class);

    private Utils() {
        throw new AssertionError((Object)"Instantiating utility class...");
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="File path is based on system properties and constants")
    public static Path getCarbonConfigHome() {
        return Paths.get(Utils.getCarbonHome().toString(), "conf");
    }

    public static Path getCarbonHome() {
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome == null) {
            carbonHome = System.getenv("CARBON_HOME");
            System.setProperty("carbon.home", carbonHome);
        }
        return Paths.get(carbonHome, new String[0]);
    }

    public static Path getRuntimePath() {
        String runtimeHome = System.getProperty("wso2.runtime.path");
        if (runtimeHome == null) {
            runtimeHome = System.getenv("RUNTIME_PATH");
            System.setProperty("wso2.runtime.path", runtimeHome);
        }
        return Paths.get(runtimeHome, new String[0]);
    }

    @SuppressFBWarnings(value={"PATH_TRAVERSAL_IN"}, justification="File path is based on system properties and constants")
    public static Path getRuntimeConfigPath() {
        return Paths.get(Utils.getCarbonHome().toString(), "conf", Utils.getRuntimeName());
    }

    public static String getRuntimeName() {
        return System.getProperty("wso2.runtime");
    }

    @SuppressFBWarnings(value={"CRLF_INJECTION_LOGS"}, justification="System generated message with system property.")
    public static String substituteVariables(String value) {
        Matcher matcher = varPattern.matcher(value);
        boolean found = matcher.find();
        if (!found) {
            return value;
        }
        StringBuffer sb = new StringBuffer();
        do {
            String sysPropKey;
            String sysPropValue;
            if ((sysPropValue = Utils.getSystemVariableValue(sysPropKey = matcher.group(1), null)) == null || sysPropValue.length() == 0) {
                String msg = "System property " + sysPropKey + " is not specified";
                logger.error(msg);
                throw new RuntimeException(msg);
            }
            sysPropValue = sysPropValue.replace("\\", "\\\\");
            matcher.appendReplacement(sb, sysPropValue);
        } while (matcher.find());
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static String getSystemVariableValue(String variableName, String defaultValue) {
        return Utils.getSystemVariableValue(variableName, defaultValue, Constants.PlaceHolders.class);
    }

    public static String getSystemVariableValue(String variableName, String defaultValue, Class constantClass) {
        String value = null;
        if (System.getProperty(variableName) != null) {
            value = System.getProperty(variableName);
        } else if (System.getenv(variableName) != null) {
            value = System.getenv(variableName);
        } else {
            try {
                String constant = variableName.replaceAll("\\.", "_").toUpperCase(Locale.getDefault());
                Field field = constantClass.getField(constant);
                value = (String)field.get(constant);
            }
            catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
                // empty catch block
            }
            if (value == null) {
                value = defaultValue;
            }
        }
        return value;
    }

    public static void checkSecurity() {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
    }

    public static List<String> getCarbonRuntimes() throws IOException {
        Path carbonRuntimeHome = Utils.getCarbonHome().resolve("wso2");
        Path osgiRepoPath = carbonRuntimeHome.resolve("lib");
        if (!Files.exists(carbonRuntimeHome, new LinkOption[0])) {
            throw new IOException("invalid carbon home path " + carbonRuntimeHome.toString());
        }
        Stream<Path> runtimes = Files.list(carbonRuntimeHome);
        ArrayList<String> runtimeNames = new ArrayList<String>();
        runtimes.filter(profile -> !osgiRepoPath.equals(profile)).filter(Objects::nonNull).forEach(profile -> runtimeNames.add(profile.getFileName().toString()));
        if (runtimeNames.size() == 0) {
            throw new IOException("No runtime found in path " + carbonRuntimeHome);
        }
        return runtimeNames;
    }
}

