/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.charon3.samples.group.sample05;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.util.Scanner;
import org.apache.log4j.BasicConfigurator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatchGroupSample {
    private static final Logger logger = LoggerFactory.getLogger(PatchGroupSample.class);
    private static String patchRequestBody = "{ \"schemas\":\n      [\"urn:ietf:params:scim:api:messages:2.0:PatchOp\"],\n     \"Operations\":[\n       {\n        \"op\":\"replace\",\n        \"path\":\"members[value eq 902c246b-6245-4190-8e05-00816be7344a].display\",\n        \"value\":\"Vindula\"\n       },\n     ]\n   }";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        BasicConfigurator.configure();
        Scanner reader = new Scanner(System.in, "UTF-8");
        System.out.print("Enter the group ID : ");
        String id = reader.next();
        try {
            String inputLine;
            String url = "http://localhost:8080/scim/v2/Groups/" + id;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("PATCH");
            con.setRequestProperty("Content-Type", "application/scim+json");
            con.setDoOutput(true);
            try (FilterOutputStream wr = null;){
                wr = new DataOutputStream(con.getOutputStream());
                ((DataOutputStream)wr).writeBytes(patchRequestBody);
                ((DataOutputStream)wr).flush();
                wr.close();
            }
            int responseCode = con.getResponseCode();
            BufferedReader in = responseCode == 200 ? new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(con.getErrorStream(), "UTF-8"));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            logger.info("Response Code : " + responseCode);
            logger.info("Response Message : " + con.getResponseMessage());
            logger.info("Response Content : " + response.toString());
        }
        catch (ProtocolException e) {
            logger.error(e.getMessage());
        }
        catch (MalformedURLException e) {
            logger.error(e.getMessage());
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
    }
}

