<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:output method="html" indent="yes"/>

<xsl:param name="service" select="services/service[1]/@name"/>

<xsl:template match="/">
    <xsl:apply-templates select="services/service[@name=$service][1]"/>
</xsl:template>

<xsl:template match="service">
    <xsl:variable name="service-name">
        <xsl:call-template name="xml-name-to-javascript-name">
            <xsl:with-param name="name" select="@name"/>
        </xsl:call-template>
    </xsl:variable>

    <html>
        <head>
            <title><xsl:value-of select="$service-name"/> service documentation</title>
            <style type="text/css">
                body {font: 75%/1.5 "Lucida Grande","Lucida Sans","Microsoft Sans Serif", "Lucida Sans Unicode",verdana,sans-serif,"trebuchet ms"; color: #111; margin:0px; padding:0px}
                td {font-size:75%}
                .title {font-size: large; background-color:#BFC; padding:1em .5em .5em .5em; margin:0px}
                .subtitle {margin-top:.5em; font-weight:bold; font-size:140%}
                .content {padding:1em}
                table.operations {margin:0em .5em .5em 1em}
                tr.operation {vertical-align:top; padding-top:3em}
                td.operationName {white-space:nowrap; padding-right:1.5em; font-weight:bold}
                tr.parameters {vertical-align:top}
                td.parameter {padding:0em .5em 0em 1.5em}
                td.return {white-space:nowrap; padding: 0em .5em 1em 1.5em}
                td.type {font-style:italic}
                td.blank {width:70%}
                .documentation {margin-bottom:.5em}
                .documentationHeading {margin-bottom:.5em; font-weight:bold}
                ul {margin-top:.25em}
            </style>
        </head>
        <body>
            <h1 class="title"><em><xsl:value-of select="$service-name"/></em> service documentation</h1>
            <div class="content">
                <xsl:if test="documentation/node()">
                    <div class="description">
                        <!-- MASHUP-65 workaround -->
                        <xsl:choose>
                            <xsl:when test="not(documentation/*) and starts-with(documentation,'&lt;')"><xsl:value-of select="documentation" disable-output-escaping="yes"/></xsl:when>
                            <xsl:otherwise><xsl:copy-of select="documentation/node()"/></xsl:otherwise>
                        </xsl:choose>
                    </div>
                </xsl:if>
                <div class="operations">
                    <div class="subtitle"><xsl:value-of select="$service-name"/> operations</div>
                    <xsl:apply-templates select="operations"/>
                </div>
                <div class="subtitle">Additional resources</div>
                <div class="resources">
                    <xsl:variable name="insecure-endpoint" select="/services/service[starts-with(@address, 'http:')][1]/@address"/>
                    <xsl:variable name="secure-endpoint" select="/services/service[starts-with(@address, 'https:')][1]/@address"/>
                    <xsl:variable name="endpoint">
                        <xsl:choose>
                            <xsl:when test="$insecure-endpoint"><xsl:value-of select="$insecure-endpoint"/></xsl:when>
                            <xsl:when test="$secure-endpoint"><xsl:value-of select="$secure-endpoint"/></xsl:when>
                        </xsl:choose>
                    </xsl:variable>
                    <ul compact="compact">
                        <li>Try the service with an on-line 
                            <xsl:if test="$insecure-endpoint">
                                <a alt="HTTP Try-it page" href="{$insecure-endpoint}?tryit">HTTP</a>
                            </xsl:if>
                            <xsl:if test="$insecure-endpoint and $secure-endpoint"> or </xsl:if>
                            <xsl:if test="$secure-endpoint">
                                <a alt="HTTPS Try-it page" href="{$secure-endpoint}?tryit">HTTPS</a>
                            </xsl:if>
                            AJAX client.</li>
                        <li>View the <a alt="Source Code" href="{$endpoint}?source">Source Code</a> of the service.</li>
                        <li>View the <a alt="WSDL 2.0" href="{$endpoint}?wsdl2&amp;annotation=true">WSDL 2.0</a> description.</li>
                        <li>View the <a alt="WSDL 1.1" href="{$endpoint}?wsdl&amp;annotation=true">WSDL 1.1</a> description.</li>
                        <li>View the <a alt="XML Schema" href="{$endpoint}?xsd&amp;annotation=true">XML Schema</a> of the message types.</li>
                     </ul>
                </div>
            </div>
        </body> 
    </html>
</xsl:template>
    
<xsl:template match="operations">
    <table class="operations">
        <xsl:apply-templates />
    </table>    
</xsl:template>

<xsl:template match="operation">
    <xsl:variable name="name">
        <xsl:call-template name="xml-name-to-javascript-name">
            <xsl:with-param name="name" select="@name"/>
        </xsl:call-template>
    </xsl:variable>
    <tr class="operation">
        <td class="operationName" rowspan="{count(signature/params/param) +2}"><xsl:value-of select="$name"/>
            <xsl:text> (</xsl:text>
            <xsl:for-each select="signature/params/param">
                <xsl:if test="position() != 1">, </xsl:if>
                <xsl:if test="(position() mod 4) = 0"><br/>&#160;&#160;&#160;</xsl:if>
                <xsl:value-of select="@name"/>
            </xsl:for-each>
            <xsl:text>)</xsl:text>
        </td>
        <td colspan="3">
            <xsl:if test="documentation/node()">
                <div class="documentation">
                    <!-- MASHUP-65 workaround -->
                    <xsl:choose>
                        <xsl:when test="not(documentation/*) and starts-with(documentation,'&lt;')"><xsl:value-of select="documentation" disable-output-escaping="yes"/></xsl:when>
                        <xsl:otherwise><xsl:copy-of select="documentation/node()"/></xsl:otherwise>
                    </xsl:choose>
                </div>
            </xsl:if>
            <div class="documentationHeading">Parameters:</div>
        </td>
    </tr>
    <xsl:for-each select="signature/params/param">
        <tr class="parameters">
            <td class="parameter"><xsl:value-of select="@name"/></td>
            <td class="type"><xsl:value-of select="@type"/></td>
            <td class="blank"/>
        </tr>
    </xsl:for-each>
    <xsl:for-each select="signature/returns/param">
        <tr class="parameters">
            <td class="return">(return value)</td>
            <td class="type"><xsl:value-of select="@type"/></td>
            <td class="blank"/>
        </tr>
    </xsl:for-each>
</xsl:template>

<xsl:template name="return-type">
    <xsl:text>/* </xsl:text>
    <xsl:if test="@maxOccurs = 'unbounded' or @maxOccurs > 1">array of </xsl:if>
    <xsl:call-template name="xml-name-to-javascript-name">
        <xsl:with-param name="name" select="@type"/>
    </xsl:call-template>
    <xsl:text>*/</xsl:text>
</xsl:template>

<xsl:template name="xml-name-to-javascript-name">
    <xsl:param name="name"/>
    <xsl:value-of select="translate($name,'.-','__')"/>
</xsl:template>

</xsl:stylesheet>