<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <xsl:output method="text"/>
	
    <xsl:param name="service" select="services/service[1]/@name"/>
    <xsl:param name="e4x" select="false()"/>
    
    <xsl:template match="/">
        <xsl:apply-templates select="services/service[@name=$service][1]"/>
    </xsl:template>
    
    <xsl:template match="service">
        <xsl:variable name="service-name">
        <xsl:call-template name="xml-name-to-javascript-name">
            <xsl:with-param name="name" select="@name"/>
        </xsl:call-template>
    </xsl:variable>
//  Example stubs for <xsl:value-of select="$service-name"/> operations.  This function is not intended 
//  to be called, but rather as a source for copy-and-paste development.

function stubs()
{
<xsl:for-each select="operations/operation">
    <xsl:variable name="name">
        <xsl:call-template name="xml-name-to-javascript-name">
            <xsl:with-param name="name" select="@name"/>
        </xsl:call-template>
    </xsl:variable>    // <xsl:value-of select="$name"/> operation
    try {
        <xsl:for-each select="signature/returns/param"><xsl:call-template name="return-type"/></xsl:for-each>
        <xsl:text> </xsl:text>
        <xsl:value-of select="$name"/>Return = <xsl:value-of select="$service-name"/>.<xsl:value-of select="$name"/>(<xsl:call-template name="parameters"><xsl:with-param name="prefix" select="'param_'"/></xsl:call-template>);
    } catch (e) {
        // fault handling
    }

</xsl:for-each>}
stubs.visible = false;

var <xsl:value-of select="$service-name"/> = new WebService("<xsl:for-each select="/services/service[@name=$service-name]">
            <xsl:sort select="@type = 'SOAP12'" order="descending"/>
            <xsl:sort select="@type = 'SOAP11'" order="descending"/>
            <xsl:sort select="@address" order="ascending"/>
            <xsl:if test="position() = 1"><xsl:value-of select="@endpoint"/></xsl:if>
        </xsl:for-each>");

<xsl:for-each select="operations/operation">
    <xsl:variable name="name">
    <xsl:call-template name="xml-name-to-javascript-name">
        <xsl:with-param name="name" select="@name"/>
    </xsl:call-template>
</xsl:variable>
<xsl:value-of select="$service-name"/>.<xsl:value-of select="$name"/> =
    function <xsl:value-of select="$name"/>(<xsl:call-template name="parameters"/>)
    {
        var isAsync, request, response, resultValue;
        <xsl:call-template name="build-arrays"/>
        this._options = new Array();
        isAsync = (this.<xsl:value-of select="$name"/>.callback != null &amp;&amp; typeof(this.<xsl:value-of select="$name"/>.callback) == 'function');
        request = 
            <xsl:call-template name="payload"/><xsl:text>
        </xsl:text>
        if (isAsync) {
            try {
                this._call(
                    "<xsl:value-of select="$name"/>",
                    request,
                    function(thisRequest, callbacks) {
                        if (thisRequest.error != null) {
                            callbacks[1](thisRequest.error);
                        } else {
                            response = thisRequest.responseXML;
                            if (response == null) {
                                resultValue = null;
                            } else {
                            <xsl:choose>
                                <xsl:when test="signature/returns/param/@maxOccurs = 'unbounded' or signature/returns/param/@maxOccurs > 1">
                                    <xsl:apply-templates select="signature/returns/param" mode="convert-array"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:apply-templates select="signature/returns/param" mode="convert"/>
                                </xsl:otherwise>
                            </xsl:choose>                            }
                            callbacks[0](resultValue);
                        }
                    },
                    new Array(this.<xsl:value-of select="$name"/>.callback, this.<xsl:value-of select="$name"/>.onError)
                );
            } catch (e) {
                var error;
                if (WebServiceError.prototype.isPrototypeOf(e)) {
                    error = e;
                } else if (typeof(e) == "string") {
                    error = new WebServiceError(e, "Internal Error");
                } else {
                    error = new WebServiceError(e.description, e.number, e.number);
                }
                this.<xsl:value-of select="$name"/>.onError(error);
            }
        } else {
            try {
                                response = this._call("<xsl:value-of select="$name"/>", request);
                            <xsl:choose>
                                <xsl:when test="signature/returns/param/@maxOccurs = 'unbounded' or signature/returns/param/@maxOccurs > 1">
                                    <xsl:apply-templates select="signature/returns/param" mode="convert-array"/>
                                </xsl:when>
                                <xsl:otherwise>
                                    <xsl:apply-templates select="signature/returns/param" mode="convert"/>
                                </xsl:otherwise>
                            </xsl:choose>                                return resultValue;
            } catch (e) {
                if (typeof(e) == "string") throw(e);
                if (e.message) throw(e.message);
                throw (e.reason + e.detail);
            }
        }
        return null; // Suppress warnings when there is no return.
    }
<xsl:value-of select="$service-name"/>.<xsl:value-of select="$name"/>.callback = null;

</xsl:for-each>

// WebService object.
function WebService(endpointName)
{
    this.readyState = 0;
    this.onreadystatechange = null;
    
    //public accessors for manually intervening in setting the address (e.g. supporting tcpmon)
    this.getAddress = function (endpointName)
    {
        return this._endpointDetails[endpointName].address;
    }
    
    this.setAddress = function (endpointName, address)
    {
        this._endpointDetails[endpointName].address = address;
    }

    // private helper functions
    this._getWSRequest = function()
    {
        var wsrequest;
        try {
            wsrequest = new WSRequest();
        } catch(e) {
            try {
                wsrequest = new ActiveXObject("WSRequest");
            } catch(e) {
                try {
                    wsrequest = new SOAPHttpRequest();
                    netscape.security.PrivilegeManager.enablePrivilege("UniversalXPConnect");
                } catch (e) {
                    throw new WebServiceError("WSRequest object not defined.", "WebService._getWSRequest() cannot instantiate WSRequest object.");
                }
            }
        }
        return wsrequest;
    }
        
    this._endpointDetails = 
        {<xsl:for-each select="/services/service[@name=$service-name]">
            <xsl:sort select="@type = 'SOAP12'" order="descending"/>
            <xsl:sort select="@type = 'SOAP11'" order="descending"/>
            <xsl:sort select="@address" order="ascending"/>
            "<xsl:value-of select="@endpoint"/>": {
                "type" : "<xsl:value-of select="@type"/>",
                "address" : "<xsl:value-of select="@address"/>"<xsl:if test="operations/operation/binding-details/@wsawaction">,
                "action" : {<xsl:for-each select="operations/operation">
                    "<xsl:value-of select="@name"/>" : "<xsl:value-of select="binding-details/@wsawaction"/>"<xsl:if test="position() &lt; last()">,</xsl:if>
                    </xsl:for-each>
                }</xsl:if>
                <xsl:if test="operations/operation/binding-details/@soapaction">,
                "soapaction" : {<xsl:for-each select="operations/operation">
                    "<xsl:value-of select="@name"/>" : "<xsl:value-of select="binding-details/@soapaction"/>"<xsl:if test="position() &lt; last()">,</xsl:if>
                    </xsl:for-each>
                }</xsl:if><xsl:if test="operations/operation/binding-details/@httplocation">,
                "httplocation" : {<xsl:for-each select="operations/operation">
                    "<xsl:value-of select="@name"/>" : "<xsl:value-of select="binding-details/@httplocation"/>"<xsl:if test="position() &lt; last()">,</xsl:if>
                    </xsl:for-each>
                }</xsl:if><xsl:if test="operations/operation/binding-details/@httpignoreUncited">,
                "httpignoreUncited" : {<xsl:for-each select="operations/operation">
                        "<xsl:value-of select="@name"/>" : "<xsl:value-of select="binding-details/@httpignoreUncited"/>"<xsl:if test="position() &lt; last()">,</xsl:if>
                    </xsl:for-each>
                }</xsl:if><xsl:if test="operations/operation/binding-details/@httpmethod">,
                "httpmethod" : {<xsl:for-each select="operations/operation">
                        "<xsl:value-of select="@name"/>" : <xsl:choose>
                            <xsl:when test="binding-details/@httpmethod">"<xsl:value-of select="binding-details/@httpmethod"/>"</xsl:when>
                            <xsl:otherwise>null</xsl:otherwise>
                    </xsl:choose><xsl:if test="position() &lt; last()">,</xsl:if>
                    </xsl:for-each>
                }</xsl:if><xsl:if test="operations/operation/binding-details/@httpqueryParameterSeparator">,
                "httpqueryParameterSeparator" : {<xsl:for-each select="operations/operation">
                        "<xsl:value-of select="@name"/>" : "<xsl:value-of select="binding-details/@httpqueryParameterSeparator"/>"<xsl:if test="position() &lt; last()">,</xsl:if>
                    </xsl:for-each>
                }</xsl:if><xsl:if test="operations/operation/binding-details/@httpinputSerialization">,
                "httpinputSerialization" : {<xsl:for-each select="operations/operation">
                        "<xsl:value-of select="@name"/>" : "<xsl:value-of select="binding-details/@httpinputSerialization"/>"<xsl:if test="position() &lt; last()">,</xsl:if>
                    </xsl:for-each>
                }</xsl:if>
            }<xsl:if test="position() &lt; last()">,</xsl:if></xsl:for-each>
    };
    this.endpoint = endpointName;

    this._encodeXML = function (value) {
        var re;
        var str = value.toString();
        re = /&amp;/g;
        str = str.replace(re, "&amp;amp;");
        re = /&lt;/g;
        str = str.replace(re, "&amp;lt;");
       return(str);
    };

    this._call = function (opName, reqContent, callback, userdata)
    {
        var details = this._endpointDetails[this.endpoint];
        if (details.type == 'SOAP12') this._options.useSOAP = 1.2;
        else if (details.type == 'SOAP11') this._options.useSOAP = 1.1;
        else if (details.type == 'HTTP') this._options.useSOAP = false;

        if (details.action != null) {
            this._options.useWSA = true;
            this._options.action = details.action[opName];
        } else if (details.soapaction != null) {
            this._options.useWSA = false;
            this._options.action = details.soapaction[opName];
        } else {
            this._options.useWSA = false;
            this._options.action = undefined;
        }
        
        if (details["httpmethod"] != null) {
            this._options.HTTPMethod = details.httpmethod[opName];
        } else {
            this._options.HTTPMethod = null;
        }
        
        if (details["httpinputSerialization"] != null) {
            this._options.HTTPInputSerialization = details.httpinputSerialization[opName];
        } else {
            this._options.HTTPInputSerialization= null;
        }
        
        if (details["httplocation"] != null) {
            this._options.HTTPLocation = details.httplocation[opName];
        } else {
            this._options.HTTPLocation = null;
        }
        
        if (details["httpignoreUncited"] != null) {
            this._options.HTTPLocationIgnoreUncited = details.httpignoreUncited[opName];
        } else {
            this._options.HTTPLocationIgnoreUncited = null;
        }

        if (details["httpqueryParameterSeparator"] != null) {
            this._options.HTTPQueryParameterSeparator = details.httpqueryParameterSeparator[opName];
        } else {
            this._options.HTTPQueryParameterSeparator = null;
        }
        
        var isAsync = (typeof(callback) == 'function');
        
        var thisRequest = this._getWSRequest();
        if (isAsync) {
            thisRequest._userdata = userdata;
            thisRequest.onreadystatechange = 
                function() {
                    if (thisRequest.readyState == 4) {
                        callback(thisRequest, userdata);
                    }
                }
        }
        thisRequest.open(this._options, details.address, isAsync);
        thisRequest.send(reqContent);
        if (isAsync) {
            return "";
        } else {
            try {
                var resultContent = thisRequest.responseText;
                if (resultContent == "") { 
                    throw new WebServiceError("No response", "WebService._call() did not recieve a response to a synchronous request.");
                }
                var resultXML = thisRequest.responseXML;
            } catch (e) {
                throw new WebServiceError(e);
            }
            return resultXML;
        }
    }				
}
WebService.visible = false;
        
<xsl:if test="operations/operation//param[@maxOccurs = 'unbounded' or @maxOccurs > 1]">// library function for dynamically converting an element with js:type annotation to a Javascript type.
function convertJSType(element, type) {
    if (element == null) return "";
    <xsl:choose>
        <xsl:when test="$e4x">var extractedValue = element"<xsl:value-of select="@name"/>"].toString();</xsl:when>
        <xsl:otherwise>var extractedValue = WSRequest.util._stringValue(element);</xsl:otherwise>
    </xsl:choose>
    var resultValue;
    switch (element.getAttribute("js:type")) {
        case "string":
            return extractedValue;
            break;
        case "number":
            return parseFloat(extractedValue);
            break;
        case "boolean":
            return extractedValue == "true" || extractedValue == "1";
            break;
        case "date":
            return xs_dateTime_to_date(extractedValue);
            break;
        case "array":
            resultValue = new Array();
            for (var i=0; i&lt;element.childNodes.length; i++) {
                resultValue = resultValue.concat(convertJSType(element.childNodes[i]));
            }
            return(resultValue);
            break;
        case "object":
            resultValue = new Object();
            for (var i=0; i&lt;element.childNodes.length; i++) {
                resultValue[element.childNodes[i].tagName] = convertJSType(element.childNodes[i]);
            }
            return(resultValue);
            break;
        case "xmllist":
            return element.childNodes;
            break;
        case "xml":
            return WSRequest.util._serializeToString(element.firstChild);
            break;
        default:
            alert("default");
            return extractedValue;
            break;
    }
}
</xsl:if>
<xsl:if test="operations/operation//param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
    ( @type = 'date' or
      @type = 'dateTime' or
      @type = 'time'
    ) or (@maxOccurs = 'unbounded' or @maxOccurs > 1)]">// library function for parsing xs:date, xs:time, and xs:dateTime types into Date objects.
function xs_dateTime_to_date(dateTime)
{
    var buffer = dateTime;
    var p = 0; // pointer to current parse location in buffer.

    var era, year, month, day, hour, minute, second, millisecond;
    
    // parse date, if there is one.
    if (buffer.substr(p,1) == '-')
    {
        era = -1;
        p++;
    } else {
        era = 1;
    }
    
    if (buffer.charAt(p+2) != ':')
    {
        year = era * buffer.substr(p,4);
        p += 5;
        month = buffer.substr(p,2);
        p += 3;
        day = buffer.substr(p,2);
        p += 3;
    } else {
        year = 1970;
        month = 1;
        day = 1;
    }
    
    // parse time, if there is one
    if (buffer.charAt(p) != '+' &amp;&amp; buffer.charAt(p) != '-')
    {
        hour = buffer.substr(p,2);
        p += 3;
        minute = buffer.substr(p,2);
        p += 3;
        second = buffer.substr(p,2);
        p += 2;
        if (buffer.charAt(p) == '.')
        {
            millisecond = parseFloat(buffer.substr(p))*1000;
            // Note that JS fractional seconds are significant to 3 places - xs:time is significant to more - 
            // though implementations are only required to carry 3 places.
            p++;
            while (buffer.charCodeAt(p) >= 48 &amp;&amp; buffer.charCodeAt(p) &lt;= 57) p++;
        } else {
            millisecond = 0;
        }
    } else {
        hour = 0;
        minute = 0;
        second = 0;
        millisecond = 0;
    }
    
    var tzhour = 0;
    var tzminute = 0;
    // parse time zone
    if (buffer.charAt(p) != 'Z' &amp;&amp; buffer.charAt(p) != '') {
        var sign = (buffer.charAt(p) == '-' ? -1 : +1);
        p++;
        tzhour = sign * buffer.substr(p,2);
        p += 3;
        tzminute = sign * buffer.substr(p,2);
    }
    
    var thisDate = new Date();
    thisDate.setUTCFullYear(year);
    thisDate.setUTCMonth(month-1);
    thisDate.setUTCDate(day);
    thisDate.setUTCHours(hour);
    thisDate.setUTCMinutes(minute);
    thisDate.setUTCSeconds(second);
    thisDate.setUTCMilliseconds(millisecond);    
    thisDate.setUTCHours(thisDate.getUTCHours() - tzhour);
    thisDate.setUTCMinutes(thisDate.getUTCMinutes() - tzminute);
    return thisDate;
}
xs_dateTime_to_date.visible = false;</xsl:if>
</xsl:template>

    <!-- Note that QName is treated lexically at this point, although the prefix is meaningless
         outside the appropriate namespace context. Before bothering to fix it, we should ensure
         that QName parameters actually are serialized with appropriate namespace declarations. -->
    <xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                              ( @type = 'string' or
                                @type = 'normalizedString' or
                                @type = 'token' or
                                @type = 'language' or
                                @type = 'Name' or
                                @type = 'NCName' or
                                @type = 'ID' or
                                @type = 'IDREF' or
                                @type = 'NMTOKEN' or
                                @type = 'ENTITY' or
                                @type = 'anyURI' or
                                @type = 'hexBinary' or
                                @type = 'base64Binary' or
                                @type = 'decimal' or
                                @type = 'NOTATION' or
                                @type = 'duration' or
                                @type = 'QName'
                              )]" mode="convert">
                                <xsl:call-template name="extracted-value"/>
                                resultValue = <xsl:call-template name="return-type"/> extractedValue;
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                            ( @type = 'string' or
                              @type = 'normalizedString' or
                              @type = 'token' or
                              @type = 'language' or
                              @type = 'Name' or
                              @type = 'NCName' or
                              @type = 'ID' or
                              @type = 'IDREF' or
                              @type = 'NMTOKEN' or
                              @type = 'ENTITY' or
                              @type = 'anyURI' or
                              @type = 'hexBinary' or
                              @type = 'base64Binary' or
                              @type = 'decimal' or
                              @type = 'NOTATION' or
                              @type = 'duration' or
                              @type = 'QName'
                            )]" mode="convert-array">
                                <xsl:call-template name="extracted-values">
                                    <xsl:with-param name="extraction-code">extractedValue</xsl:with-param>
                                </xsl:call-template>
                                resultValue = <xsl:call-template name="return-type"/> extractedValues;
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                              ( @type = 'integer' or
                                @type = 'nonPositiveInteger' or
                                @type = 'negativeInteger' or
                                @type = 'long' or
                                @type = 'int' or
                                @type = 'short' or
                                @type = 'byte' or
                                @type = 'nonNegativeInteger' or
                                @type = 'unsignedLong' or
                                @type = 'unsignedInt' or
                                @type = 'unsignedShort' or
                                @type = 'unsignedByte' or
                                @type = 'positiveInteger' or
                                @type = 'gYear' or
                                @type = 'gMonth' or
                                @type = 'gDay' 
                              )]" mode="convert">
                                <xsl:call-template name="extracted-value"/>
                                resultValue = <xsl:call-template name="return-type"/> parseInt(extractedValue);
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                            ( @type = 'integer' or
                              @type = 'nonPositiveInteger' or
                              @type = 'negativeInteger' or
                              @type = 'long' or
                              @type = 'int' or
                              @type = 'short' or
                              @type = 'byte' or
                              @type = 'nonNegativeInteger' or
                              @type = 'unsignedLong' or
                              @type = 'unsignedInt' or
                              @type = 'unsignedShort' or
                              @type = 'unsignedByte' or
                              @type = 'positiveInteger' or
                              @type = 'gYear' or
                              @type = 'gMonth' or
                              @type = 'gDay' 
                            )]" mode="convert-array">
                                <xsl:call-template name="extracted-values">
                                    <xsl:with-param name="extraction-code">(extractedValue == "INF" || extractedValue == "+INF" ? Infinity : (extractedValue == "-INF" ? -Infinity : parseInt(extractedValue)))</xsl:with-param>
                                </xsl:call-template>
                                resultValue = <xsl:call-template name="return-type"/> extractedValues;
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                              ( @type = 'float' or
                                @type = 'double'
                              )]" mode="convert">
                                <xsl:call-template name="extracted-value"/>
                                resultValue;
                                if (extractedValue == "INF" || extractedValue == "+INF")
                                    resultValue = Infinity;
                                else if (extractedValue == "-INF")
                                    resultValue = -Infinity;
                                else resultValue = <xsl:call-template name="return-type"/> parseFloat(extractedValue);
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                            ( @type = 'float' or
                              @type = 'double'
                            )]" mode="convert-array">
                                <xsl:call-template name="extracted-values">
                                    <xsl:with-param name="extraction-code">(extractedValue == "INF" || extractedValue == "+INF" ? Infinity : (extractedValue == "-INF" ? -Infinity : parseFloat(extractedValue)))</xsl:with-param>
                                </xsl:call-template>
                                resultValue = <xsl:call-template name="return-type"/> extractedValues;
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                              ( @type = 'boolean' )]" mode="convert">
                                <xsl:call-template name="extracted-value"/>
                                resultValue = /* Boolean */ extractedValue == "true" || extractedValue == "1";
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                              ( @type = 'boolean' )]" mode="convert-array">
                                <xsl:call-template name="extracted-values">
                                    <xsl:with-param name="extraction-code">extractedValue == "true" || extractedValue == "1"</xsl:with-param>
                                </xsl:call-template>
                                resultValue = <xsl:call-template name="return-type"/> extractedValues;
</xsl:template>
    
<!-- todo: Do a better job than String for the following date types 
    <simple type="xs:gMonthDay"/>
    <simple type="xs:gYearMonth"/>
-->
<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                            ( @type = 'gMonthDay' or
                              @type = 'gYearMonth'
                            )]" mode="convert">
                                <xsl:call-template name="extracted-value"/>
                                resultValue = <xsl:call-template name="return-type"/> extractedValue.toString();
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                            ( @type = 'gMonthDay' or
                              @type = 'gYearMonth'
                             )]" mode="convert-array">
                                <xsl:call-template name="extracted-values">
                                    <xsl:with-param name="extraction-code">extractedValue.toString()</xsl:with-param>
                                </xsl:call-template>
                                resultValue = <xsl:call-template name="return-type"/> extractedValues;
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                        ( @type = 'date' or
                          @type = 'dateTime' or
                          @type = 'time'
                        )]" mode="convert">
                                <xsl:call-template name="extracted-value"/>
                                resultValue = /* Date */ xs_dateTime_to_date(extractedValue);
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                        ( @type = 'date' or
                          @type = 'dateTime' or
                          @type = 'time'
                        )]" mode="convert-array">
                                <xsl:call-template name="extracted-values">
                                    <xsl:with-param name="extraction-code">xs_dateTime_to_date(extractedValue)</xsl:with-param>
                                </xsl:call-template>
                                resultValue = <xsl:call-template name="return-type"/> extractedValues;
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                            ( @type = 'ENTITIES' )]" mode="convert">
                                <xsl:call-template name="extracted-value"/>
                                resultValue = /* array of xs:ENTITY */ extractedValue.split(' '));
</xsl:template>
    
<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                            ( @type = 'IDREFS' )]" mode="convert">
                                <xsl:call-template name="extracted-value"/>
                                resultValue = /* array of xs:IDREF */ extractedValue.split(' '));
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                            ( @type = 'NMTOKENS' )]" mode="convert">
                                <xsl:call-template name="extracted-value"/>
                                resultValue = /* array of xs:NMTOKEN */ extractedValue.split(' '));
</xsl:template>
    
<xsl:template match="param[@name][@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                          ( @type = 'anyType' )]" mode="convert">
    <xsl:choose>
        <xsl:when test="$e4x">    resultValue = /* xs:anyType */ response["<xsl:value-of select="@name"/>"].*;
</xsl:when>
        <xsl:otherwise>    resultValue = /* xs:anyType */ response.documentElement.firstChild.firstChild;
</xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="param[not(@name)][@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                           ( @type = 'anyType' )]" mode="convert">
    <xsl:choose>
        <xsl:when test="$e4x">    resultValue = /* xs:anyType */ response;
</xsl:when>
        <xsl:otherwise>    resultValue = /* xs:anyType */ response.documentElement;
</xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="param[@type-namespace = 'http://www.w3.org/2001/XMLSchema' and
                           ( @type = 'anyType' )]" mode="convert-array">
    <xsl:choose>
        <xsl:when test="$e4x">    resultValue = /* xs:anyType */ convertJSType(response["<xsl:value-of select="@name"/>"].*);
</xsl:when>
        <xsl:otherwise>    resultValue = convertJSType(response.documentElement.firstChild);
</xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="param" mode="convert">
    <xsl:choose>
        <xsl:when test="$e4x">    resultValue = <xsl:call-template name="return-type"/> response;
</xsl:when>
        <xsl:otherwise>    resultValue = <xsl:call-template name="return-type"/> response.documentElement;
</xsl:otherwise>
    </xsl:choose>
</xsl:template>
    
<xsl:template match="param" mode="convert-array">
    <xsl:choose>
        <xsl:when test="$e4x">    resultValue = <xsl:call-template name="return-type"/> response;
</xsl:when>
        <xsl:otherwise>    resultValue = <xsl:call-template name="return-type"/> response.documentElement;
</xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!-- 
<xsl:template match="param" mode="convert-array">
    <xsl:choose>
        <xsl:when test="$e4x">    resultValue = &lt;&gt;{response.*}&lt;/&gt;;
</xsl:when>
        <xsl:otherwise>    var extractedItems = response.documentElement.childNodes;
                                var extractedValues = new Array();
                                for (var i=0; i&lt;extractedItems.length; i++) {
                                    extractedValues = extractedValues.concat(extractedItems.item(i));
                                }
                                resultValue = <xsl:call-template name="return-type"/> extractedValues;
</xsl:otherwise>
    </xsl:choose>
</xsl:template>
-->    
<xsl:template name="extracted-value">
    <xsl:choose>
        <xsl:when test="$e4x">    var ns = new Namespace("<xsl:value-of select="../@wrapper-element-ns"/>");
                                var extractedValue = response.ns::<xsl:value-of select="../@wrapper-element"/>["<xsl:value-of select="@name"/>"].toString();</xsl:when>
        <xsl:otherwise>    var extractedValue = WSRequest.util._stringValue(response.documentElement);</xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="extracted-values">
    <xsl:param name="extraction-code"/>
    <xsl:choose>
        <!-- TODO E4X arrays -->
        <xsl:when test="$e4x">    var ns = new Namespace("<xsl:value-of select="../@wrapper-element-ns"/>");
            var extractedValue = response.ns::<xsl:value-of select="../@wrapper-element"/>["<xsl:value-of select="@name"/>"].toString();</xsl:when>
        <xsl:otherwise>    var extractedItems = response.documentElement.childNodes;
                                var extractedValues = new Array();
                                for (var i=0; i&lt;extractedItems.length; i++) {
                                    var node = extractedItems.item(i);
                                    if (node.nodeType == 1) {
                                        var extractedValue = WSRequest.util._stringValue(node);
                                        extractedValues = extractedValues.concat(<xsl:value-of select="$extraction-code"/>);
                                    }
                                }</xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="parameters">
    <xsl:param name="prefix" select="'_'"/>
    <xsl:for-each select="signature/params/param">
        <xsl:choose>
            <xsl:when test="@token = '#any'">/* XMLList */ additionalParameters</xsl:when>
            <xsl:otherwise>/* <xsl:if test="@maxOccurs = 'unbounded' or @maxOccurs > 1">array of </xsl:if><xsl:value-of select="@type"/> */ <xsl:value-of select="$prefix"/><xsl:value-of select="@name"/></xsl:otherwise>
        </xsl:choose>
        <xsl:if test="position() != last()">, </xsl:if>
    </xsl:for-each>
</xsl:template>

<xsl:template name="payload">
    <xsl:choose>
        <xsl:when test="signature/params/@wrapper-element">'&lt;p:<xsl:value-of select="signature/params/@wrapper-element"/> xmlns:p="<xsl:value-of select="signature/params/@wrapper-element-ns"/>
            <xsl:text>"&gt;' +</xsl:text>
            <xsl:for-each select="signature/params/param">
            <xsl:choose>
                <xsl:when test="@token = '#any'">
                additionalParameters + '</xsl:when>
                <xsl:when test="@maxOccurs = 'unbounded' or @maxOccurs > 1">
                _array_of_<xsl:value-of select="@name"/> + </xsl:when>
                <xsl:when test="@type = 'anyType' and @type-namespace='http://www.w3.org/2001/XMLSchema'">
                (_<xsl:value-of select="@name"/> == null ? '' : '&lt;<xsl:value-of select="@name"/><xsl:if test="@targetNamespace"> xmlns="<xsl:value-of select="@targetNamespace"/>"</xsl:if>&gt;' + _<xsl:value-of select="@name"/> + '&lt;/<xsl:value-of select="@name"/>&gt;') +</xsl:when>
                <xsl:when test="@simple = 'yes'">
                (_<xsl:value-of select="@name"/> == null ? '' : '&lt;<xsl:value-of select="@name"/><xsl:if test="@targetNamespace"> xmlns="<xsl:value-of select="@targetNamespace"/>"</xsl:if>&gt;' + this._encodeXML(_<xsl:value-of select="@name"/>) + '&lt;/<xsl:value-of select="@name"/>&gt;') +</xsl:when>
                <xsl:otherwise>
                (_<xsl:value-of select="@name"/> == null ? '' : '&lt;<xsl:value-of select="@name"/><xsl:if test="@targetNamespace"> xmlns="<xsl:value-of select="@targetNamespace"/>"</xsl:if>&gt;' + _<xsl:value-of select="@name"/> + '&lt;/<xsl:value-of select="@name"/>&gt;') +</xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            '&lt;/p:<xsl:value-of select="signature/params/@wrapper-element"/>&gt;' ;</xsl:when>
        <xsl:when test="signature/params/param[@type = 'anyType' and @type-namespace='http://www.w3.org/2001/XMLSchema']">_<xsl:value-of select="signature/params/param/@name"/>;</xsl:when>
        <xsl:when test="not(signature/params/param)">"";</xsl:when>
        <xsl:otherwise>"&lt;<xsl:value-of select="@name"/>/&gt;";<!-- @@ bug - should be able to send an empty string... --></xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template name="build-arrays">
    <xsl:for-each select="signature/params/param[not(@token='#any')][@maxOccurs = 'unbounded' or @maxOccurs > 1]">
        <xsl:variable name="name">
            <xsl:call-template name="xml-name-to-javascript-name">
                <xsl:with-param name="name" select="@name"/>
            </xsl:call-template>
        </xsl:variable>
        var _array_of_<xsl:value-of select="$name"/> = '';
        for (var i=0; i &lt; _<xsl:value-of select="$name"/>.length; i++)
            _array_of_<xsl:value-of select="$name"/> += '&lt;<xsl:value-of select="$name"/><xsl:if test="@targetNamespace"> xmlns="<xsl:value-of select="@targetNamespace"/>"</xsl:if>&gt;' + <xsl:if test="(@type = 'string' or @type = 'normalizedString' or @type = 'anyURI') and @type-namespace='http://www.w3.org/2001/XMLSchema'">this._encodeXML</xsl:if>(_<xsl:value-of select="$name"/>[i]) + '&lt;/<xsl:value-of select="$name"/>&gt;';
    </xsl:for-each>
</xsl:template>

<xsl:template name="return-type">
    <xsl:text>/* </xsl:text>
    <xsl:if test="@maxOccurs = 'unbounded' or @maxOccurs > 1">array of </xsl:if>
    <xsl:call-template name="xml-name-to-javascript-name">
        <xsl:with-param name="name" select="@type"/>
    </xsl:call-template>
    <xsl:text> */</xsl:text>
</xsl:template>

    <xsl:template name="xml-name-to-javascript-name">
        <xsl:param name="name"/>
        <xsl:value-of select="translate($name,'.-','__')"/>
    </xsl:template>

</xsl:stylesheet>
