<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

    <xsl:output method="html" indent="yes"/>
	
    <xsl:param name="service" select="services/service[1]/@name"/>
    <xsl:param name="wsrequest-location" select="'/WSRequest.js'"/>
    <xsl:param name="stub-location" />
    <xsl:param name="image-path" select="'/images/'"/>
    <xsl:param name="e4x" select="false()"/>
    <xsl:param name="breadcrumbs" />
    <xsl:param name="fixendpoints" select="'true'"/>
    
    <xsl:template match="/">
        <xsl:apply-templates select="services/service[@name=$service][1]"/>
    </xsl:template>
    
    <xsl:template match="service">
        <xsl:variable name="service-name">
            <xsl:call-template name="xml-name-to-javascript-name">
                <xsl:with-param name="name" select="@name"/>
            </xsl:call-template>
        </xsl:variable>

    <html>
        <head>
            <title>Try the <xsl:value-of select="$service-name"/> service</title>
            <style type="text/css">
    body {font: 75%/1.5 "Lucida Grande","Lucida Sans","Microsoft Sans Serif", "Lucida Sans Unicode",verdana,sans-serif,"trebuchet ms"; color: #111; }
    .documentation {background-color:#BFC; padding:.5em;}
    h1 {font-size: 16px; font-weight: normal; margin-bottom:0px}
    h2 {font-size: 15px; font-weight: normal; margin-bottom:0px}
    h3 {font-size: 18px; font-weight: normal; margin-bottom:0px}
    table.ops th,
    table.ops td {padding: 0px 5px; font-size: 80%; margin:0px}
    table.ops thead th {text-align: left; vertical-align: middle; padding: 0 15px; }
    table.ops td {text-align: left; vertical-align: top; }
    table.ops td.label {text-align: right; vertical-align:baseline}
    table.ops td.param {width:90%}
    table.ops td.invoke { border-top: 1px solid #DDD; border-bottom: 1px solid #DDD; border-right: 1px solid #DDD;}
    table.ops td.operation { border-top: 1px solid white; border-bottom: 1px solid white; border-left: 1px solid white; border-right: 1px solid #DDD; vertical-align:middle}
    table.ops td.thisoperation { border-top: 1px solid #DDD; border-bottom: 1px solid #DDD; border-left: 1px solid #DDD; border-right: 1px solid white; vertical-align:middle;}
    .params {display:none; }
    textarea.nonemptyfield { height: 1.7em; overflow-x:hidden; overflow-y:auto; margin:0px}
    textarea.emptyfield { height: 1.7em; color:#CCC; overflow-x:hidden; overflow-y:auto; margin:0px}
    .typeannotation {color:#CCC;}
    .output {font-family: monospace;}
    #address {width:20em}
    table.config td {font-size: 80%; padding:.5em}
    .config {background-color:#f0f6ff; border: 1px solid #DDD;}
    .corner {position:relative; top:.58em; left:.58em; cursor:pointer}
    .cornerExpand {position:relative; top:3px; left:-12px; cursor:pointer}
    .cornerCollapse {position:relative; top:3px; left:-12px; cursor:pointer}
    #configshown {display:none}
    .configExpando {vertical-align:bottom}
    .showDetail {display:block; margin-top:1em; font-family: "Lucida Grande","Lucida Sans","Microsoft Sans Serif", "Lucida Sans Unicode",verdana,sans-serif,"trebuchet ms"}
    .faultDetail {display:none; margin-top:1em; color:darkblue}
</style>
<script type="text/javascript" src="{$wsrequest-location}"></script>
            <xsl:text>
</xsl:text>
            <xsl:variable name="e4x-param">
                <xsl:if test="$e4x">; e4x=1</xsl:if>
            </xsl:variable>
            <xsl:variable name="src">
                <xsl:choose>
                    <xsl:when test="$stub-location"><xsl:value-of select="$stub-location"/></xsl:when>
                    <xsl:when test="$e4x"><xsl:value-of select="$service-name"/>?stub&amp;lang=e4x</xsl:when>
                    <xsl:otherwise><xsl:value-of select="$service-name"/>?stub</xsl:otherwise>                    
                </xsl:choose>
            </xsl:variable>
            <script type="text/javascript{$e4x-param}" src="{$src}"></script>
            <xsl:text>
</xsl:text>
            <script>
                <xsl:attribute name="type">
                    <xsl:choose>
                        <xsl:when test="$e4x">text/javascript;e4x=1</xsl:when>
                        <xsl:otherwise>text/javascript</xsl:otherwise>
                    </xsl:choose>
                </xsl:attribute>
    var browser = WSRequest.util._getBrowser();
                
    function init() {
        <xsl:if test="$fixendpoints='true'">fixEndpoints();
        </xsl:if>selectEndpoint();
        var requestedOperation = "";
        if (document.URL.indexOf('#') >= 0)
            requestedOperation = document.URL.substring(document.URL.lastIndexOf('#') + 1);  
        if (document.getElementById("operation_" + requestedOperation) == null) {
            requestedOperation = '<xsl:value-of select="operations/operation[1]/@name"/>';
        }
        selectOperation(requestedOperation);
        // Restore the state based on the form - keeps things from getting out of sync after a page refresh.
        var textareas = document.getElementsByTagName("textarea");
        for (var i in textareas) {
            if (textareas[i].className == "emptyfield") {
                var type = "(" + textareas[i].title.substring(textareas[i].title.indexOf(' ')+1, textareas[i].title.indexOf(' ',textareas[i].title.indexOf(' ')+1)) + ")";
                if (textareas[i].value == '')
                    textareas[i].value = type;
                else if (textareas[i].value != type)
                    textareas[i].className = 'nonemptyfield';
            }
        }
    }
<xsl:for-each select="operations/operation">
    <xsl:variable name="name">
        <xsl:call-template name="xml-name-to-javascript-name">
            <xsl:with-param name="name" select="@name"/>
        </xsl:call-template>
    </xsl:variable>
    function do_<xsl:value-of select="$name"/>()
    {
        // <xsl:value-of select="$name"/> operation
        log ("console_<xsl:value-of select="$name"/>", "");
        <xsl:for-each select="signature/params/param">
            <xsl:variable name="adjusted-name">
                <xsl:choose>
                    <xsl:when test="@token = '#any'">input_<xsl:value-of select="$name"/>_additionalParameters</xsl:when>
                    <xsl:otherwise>input_<xsl:value-of select="$name"/>_<xsl:value-of select="@name"/>_0</xsl:otherwise>
                </xsl:choose>
            </xsl:variable>
            <xsl:choose>
                <xsl:when test="enumeration">param_<xsl:value-of select="@name"/> = <xsl:value-of select="$adjusted-name"/>.value</xsl:when>
                <xsl:when test="@maxOccurs &gt; 1 or @maxOccurs = 'unbounded'">param_<xsl:value-of select="@name"/> = new Array();
        var arrayDiv = document.getElementById('arrayparams_<xsl:value-of select="$name"/>_<xsl:value-of select="@name"/>');
        var arrayLength = arrayDiv.getElementsByTagName("div").length;;
        var arrayItem;
        for (var i=1; i&lt;arrayLength; i++) {
            arrayItem = arrayDiv.getElementsByTagName("div").item(i).getElementsByTagName("*").item(0);
            <xsl:choose>
                <xsl:when test="@type = 'boolean'">var param_<xsl:value-of select="@name"/> = param_<xsl:value-of select="@name"/>.concat(arrayItem.checked ? true : false);</xsl:when>
                <xsl:otherwise>if (arrayItem.className != 'emptyfield')
                var param_<xsl:value-of select="@name"/> = param_<xsl:value-of select="@name"/>.concat(arrayItem.value);</xsl:otherwise>
            </xsl:choose>
        }</xsl:when>
                <xsl:when test="@minOccurs &lt; 1">var param_<xsl:value-of select="@name"/> = null;
        if (<xsl:value-of select="$adjusted-name"/>.className!='emptyfield')
            param_<xsl:value-of select="@name"/> = <xsl:value-of select="$adjusted-name"/>.value</xsl:when>
                <xsl:when test="@type = 'boolean'">var param_<xsl:value-of select="@name"/> = (<xsl:value-of select="$adjusted-name"/>.checked ? "true" : "false")</xsl:when>
                <xsl:otherwise>param_<xsl:value-of select="@name"/> = <xsl:value-of select="$adjusted-name"/>.className=='emptyfield' ? "" : <xsl:value-of select="$adjusted-name"/>.value</xsl:otherwise>
            </xsl:choose>;
        </xsl:for-each>
        <xsl:value-of select="$service-name"/>.<xsl:value-of select="$name"/>.callback = function (payload) {
            log ("console_<xsl:value-of select="$name"/>", payload);
        };
        <xsl:value-of select="$service-name"/>.<xsl:value-of select="$name"/>.onError = function (error) {
            log ("console_<xsl:value-of select="$name"/>", "Fault: " + error.reason, error.detail);
        };
        <xsl:value-of select="$service-name"/>.<xsl:value-of select="$name"/>(<xsl:for-each select="signature/params/param">param_<xsl:value-of select="@name"/>
        <xsl:if test="position() != last()">, </xsl:if>
    </xsl:for-each>);
    }
</xsl:for-each>

    function log(consoleid, data, detail) {
        var console = document.getElementById(consoleid);
        var output = serializeAnything(data);
        if (browser == "ie" || browser == "ie7") {
            console.innerText = output;
        } else {
            console.textContent = output;
        }
        if (detail != null)
            console.innerHTML += "\n&lt;a class='showDetail' href='#' onclick='this.style.display=\"none\";this.parentNode.lastChild.style.display=\"block\"'>[detail]&lt;/a>\n&lt;div class='faultDetail'&gt;" + <xsl:value-of select="$service-name"/>._encodeXML(detail) + "&lt;/div&gt;";
    }

    // function to serialize simple types, XML, or arrays and objects
    function serializeAnything (data, quoteStrings) {
        var output = "";
        if (data == null) {
            output += "(null)";
        } else if (typeof(data) == "string") {
            if (quoteStrings) {
                output += '"' + data + '"';
            } else {
                output += data;
            }
        <xsl:if test="$e4x">} else if (typeof(data) == "xml") {
            output += payload.toXMLString();
        </xsl:if>} else if (typeof(data) == "object") {
            if (Array.prototype.isPrototypeOf(data)) {
                output += serializeArray(data);
            } else if (Date.prototype.isPrototypeOf(data)) {
                output += data;
            <xsl:if test="not($e4x)">} else if (data.nodeType != undefined) {
                output += WSRequest.util._serializeToString(data);</xsl:if>
            } else {
                output += serializeObject(data);
            }
        } else {
            output += data;
        }
        return output;
    }
    function serializeObject (obj) {
        var output = "{";
        for (var i in obj) {
            if (output != '{') output += ", ";
            output += i + " : " + serializeAnything(obj[i], true);
        }
        output += "}";
        return output;
    }
    function serializeArray (arr) {
        var output = "";
        for (var i in arr) {
            if (i != 0) output += ",";
            output += serializeAnything(arr[i]);
        }
        return output;
    }
    
    var currentOperation = "";
    var currentOperationLabel = "";
    function selectOperation(op) {
        if (currentOperation != "") {
            currentOperation.style.display = "none";
            currentOperationLabel.className = "operation";
        }
            
        currentOperation = document.getElementById("params_" + op);
        currentOperation.style.display = "block";   
        currentOperationLabel = document.getElementById("operation_" + op);
        currentOperationLabel.className = "thisoperation";
    }
    
    <xsl:if test="$fixendpoints='true'">function fixEndpoints() {
        // cross-domain sharing violations may occur if the WSDL contains fixed IPs but "localhost" is used instead.
        // this function removes endpoints that aren't reachable from this tryit (namely https vs http), links to
        // an alternate tryit page from which those endpoints can be invoked, and rewrites the domain (except port)
        // of the endpoints to match the servers.
        
        function scheme(url) {
            var s = url.substring(0, url.indexOf(':'));
            return s;
        }
        function domain(url) {
            var d = url.substring(url.indexOf('://') + 3, url.indexOf('/',url.indexOf('://')+3));
            return d;
        }
        function domainNoPort(url) {
            var d = domain(url);
            if (d.indexOf(":") >= 0)
                d = d.substring(0, d.indexOf(':'));
            return d;
        }
        var pageUrl = document.URL;
        var pageScheme = scheme(pageUrl);
        var linkFixed = false;
        if (pageScheme == "http" || pageScheme == "https") {
            var pageDomain = domain(pageUrl); 
            var endpointName = document.getElementById("endpointSelect");
            // count down so we don't mess up indices as we delete options
            for (i=endpointName.options.length - 1; i>=0; i--) {
                var endpointAddress = <xsl:value-of select="$service-name"/>.getAddress(endpointName.options[i].value);
                if (scheme(endpointAddress) != pageScheme) {
                    if (!linkFixed) {
                        var link = document.getElementById("alternate-tryit");
                        link.innerHTML = (pageScheme == "http" ? "https" : "http");
                        link.href = endpointAddress.replace(domainNoPort(endpointAddress), domainNoPort(pageUrl)) + "?tryit";
                        linkFixed = true;
                    }
                    endpointName.removeChild(endpointName.options[i]);
                } else {
                    if (domain(endpointAddress) != pageDomain) {
                        var newAddress = endpointAddress.replace(domain(endpointAddress), pageDomain);
                        <xsl:value-of select="$service-name"/>.setAddress(endpointName.options[i].value, newAddress)
                    }
                }
            }
        }
        if (linkFixed) document.getElementById("alternate-bullet").style.display = "block";
    }
    </xsl:if>
    function selectEndpoint() {
        var endpointName = document.getElementById("endpointSelect");
        var endpoint = endpointName.options[endpointName.selectedIndex].value;
        <xsl:value-of select="$service-name"/>.endpoint = endpoint;
        document.getElementById("address").value = <xsl:value-of select="$service-name"/>.getAddress(endpoint);
    }

    function addressChange() {
        var endpoint = <xsl:value-of select="$service-name"/>.endpoint;
        newEndpointAddress = document.getElementById("address").value;
        if (newEndpointAddress != null) {
            <xsl:value-of select="$service-name"/>.setAddress(endpoint, newEndpointAddress);
        }
    }

    function prepareInput(e) {
        var thisInput = sourceElement(e);
        if (thisInput.className == "emptyfield") {
            thisInput.value = "";
            thisInput.className = "nonemptyfield";
        }
    }
    
    function restoreInput(e, value) {
        var thisInput = sourceElement(e);
        if (thisInput.value == "") {
            thisInput.value = value;
            thisInput.className = "emptyfield";
        }
    }
     
    function expand(e) {
        thisExpando = sourceElement(e);
        thisInput = thisExpando.parentNode.getElementsByTagName("*").item(0);
        if (thisExpando.className == "cornerExpand") {
            thisInput.style.width = "30em";
            thisInput.style.height = "6em";
            thisExpando.className = "cornerCollapse";
            thisExpando.title = "Reduce typing space";
            thisExpando.src = "<xsl:value-of select="$image-path"/>collapse.gif";
        } else {
            thisInput.style.width = "";
            thisInput.style.height = "1.7em";
            thisExpando.className = "cornerExpand";
            thisExpando.title = "Increase typing space";
            thisExpando.src = "<xsl:value-of select="$image-path"/>expand.gif";
        }
    }

    function toggleconfig(toHide, toShow) {
        if (browser == "ie" || browser == "ie7")
            var block = "block";
        else 
            var block = "table-row";
        document.getElementById(toHide).style.display = "none";
        document.getElementById(toShow).style.display = block;
    }
    
    function addArrayItem(e) {
        var arrayDiv = sourceElement(e).parentNode.getElementsByTagName("div").item(0);
        var lastIndex = arrayDiv.getElementsByTagName("div").length - 1;
        var newItem = arrayDiv.getElementsByTagName("div").item(0).cloneNode(true);
        newItem.style.display = "block";
        newItem.getElementsByTagName("*").item(0).id += lastIndex;
        arrayDiv.appendChild(newItem);
        sourceElement(e).parentNode.lastChild.disabled = false;
    }
    function removeArrayItem(e) {
        var arrayDiv = sourceElement(e).parentNode.getElementsByTagName("div").item(0);
        var lastIndex = arrayDiv.getElementsByTagName("div").length - 1;
        arrayDiv.removeChild(arrayDiv.getElementsByTagName("div").item(lastIndex));
        if (lastIndex &lt;= 2) {
            sourceElement(e).disabled = true;
        }
    }

    function sourceElement(e) {
        // cross-browser event source
        if (browser == "ie" || browser == "ie7") return window.event.srcElement;
        var node = e.target;
        while(node.nodeType != node.ELEMENT_NODE)
            node = node.parentNode;
        return node;
    }            
                
</script>
    </head>
        <body onload="init()">
            <xsl:value-of select="$breadcrumbs" disable-output-escaping="yes"/>
            <h1>Try the <xsl:value-of select="$service-name"/> service.</h1>
            <xsl:if test="documentation/node()">
                <div class="documentation">
                    <!-- MASHUP-65 workaround -->
                    <xsl:choose>
                        <xsl:when test="not(documentation/*) and starts-with(documentation,'&lt;')"><xsl:value-of select="documentation" disable-output-escaping="yes"/></xsl:when>
                        <xsl:otherwise><xsl:copy-of select="documentation/node()"/></xsl:otherwise>
                    </xsl:choose>
                </div>
            </xsl:if>
            <div style="margin-top:.5em; margin-bottom:.5em">
                <table class="config" cellspacing="0" cellpadding="0">
                    <tr>
                        <td>Choose endpoint...</td>
                        <td class="configExpando">
                            <img id="confighidden" class="corner" src="{$image-path}expand.gif"  onclick="toggleconfig('confighidden', 'configshown')" title="Show endpoint options"/>
                        </td>
                    </tr>
                    <tr id="configshown">
                        <td>
                            <ul>
                                <li>Select an endpoint: <select id="endpointSelect" onchange="selectEndpoint()">
                                        <xsl:for-each select="/services/service[@name=$service]">
                                            <xsl:sort select="@type = 'SOAP12'" order="descending"/>
                                            <xsl:sort select="@type = 'SOAP11'" order="descending"/>
                                            <xsl:sort select="@address" order="ascending"/>
                                            <option value="{@endpoint}"><xsl:value-of select="@endpoint"/></option>
                                        </xsl:for-each>
                                    </select>
                                </li>
                                <li>Change the address for the selected endpoint: <input type="text" id="address" value="{@address}" onchange="addressChange()"/>
                                </li>
                                <li id="alternate-bullet" style="display:none">Try an alternate <a id="alternate-tryit" href="https://">https</a> endpoint.</li>
                            </ul>
                        </td>
                        <td class="configExpando">
                            <img src="{$image-path}collapse.gif" class="corner" onclick="toggleconfig('configshown', 'confighidden')" title="Hide endpoint options"/>
                        </td>
                    </tr>
                </table>
            </div>
            <table class="ops" cellspacing="0" cellpadding="0">
                <xsl:for-each select="operations/operation">
                    <xsl:variable name="name">
                        <xsl:call-template name="xml-name-to-javascript-name">
                            <xsl:with-param name="name" select="@name"/>
                        </xsl:call-template>
                    </xsl:variable>
                    <tr>
                        <td class="operation" id="operation_{$name}">
                            <a href="#{$name}" onclick="selectOperation('{$name}')"><xsl:value-of select="$name"/></a>
                        </td>
                        <xsl:if test="position() = 1">
                            <xsl:call-template name="parameter-view"/>
                        </xsl:if>
                    </tr>
                </xsl:for-each>
                <tr>
                    <td class="operation"> </td>
                </tr>
            </table>	
        </body> 
     </html>
    </xsl:template>
    
    <xsl:template name="parameter-view">
        <td class="invoke" rowspan="{count(../operation) + 2}">
            <xsl:for-each select="../operation">
                <xsl:variable name="name">
                    <xsl:call-template name="xml-name-to-javascript-name">
                        <xsl:with-param name="name" select="@name"/>
                    </xsl:call-template>
                </xsl:variable>
                <div class="params" id="params_{$name}">
                    <table class="ops">
                        <xsl:if test="documentation/node()">
                            <tr>
                                <td colspan="2" class="documentation">
                                    <!-- MASHUP-65 workaround -->
                                    <xsl:choose>
                                        <xsl:when test="not(documentation/*) and starts-with(documentation,'&lt;')"><xsl:value-of select="documentation" disable-output-escaping="yes"/></xsl:when>
                                        <xsl:otherwise><xsl:copy-of select="documentation/node()"/></xsl:otherwise>
                                    </xsl:choose>
                                </td>    
                            </tr>
                        </xsl:if>
                        <xsl:for-each select="signature/params/param">
                            <tr>
                                <xsl:choose>
                                    <xsl:when test="@token = '#any'">
                                        <td class="label">(additional parameters)</td>
                                        <td class="param">
                                            <input type="text" id="input_{$name}_additionalParameters" class="emptyfield" value="xs:anyType"  onfocus="prepareInput(event)" onblur="restoreInput(event,'(xs:anyType)')" />
                                            <!-- TODO expandable fields of additional parameters -->
                                        </td>
                                    </xsl:when>
                                    <xsl:when test="@type = 'boolean'">
                                        <td class="label">
                                            <xsl:value-of select="@name"/>
                                            <xsl:if test="@minOccurs &lt; 1 or @maxOccurs &gt; 1 or @maxOccurs = 'unbounded'"><sub>(<xsl:value-of select="@minOccurs"/>..<xsl:choose><xsl:when test="@maxOccurs = 'unbounded'">*</xsl:when><xsl:otherwise><xsl:value-of select="@maxOccurs"/></xsl:otherwise></xsl:choose>)</sub></xsl:if></td>
                                        <td class="param">
                                            <div id="arrayparams_{$name}_{@name}">
                                                <!-- hidden template for additional array items -->
                                                <div style="display:none">
                                                    <input type="checkbox" id="input_{$name}_{@name}_" title="An xs:boolean value representing {@name}"/><span class="typeannotation"> (xs:boolean)</span>
                                                </div>
                                                <div>
                                                    <input type="checkbox" id="input_{$name}_{@name}_0" title="An xs:boolean value representing {@name}"/><span class="typeannotation"> (xs:boolean)</span>
                                                </div>
                                            </div>
                                            <xsl:if test="@maxOccurs &gt; 1 or @maxOccurs = 'unbounded'">
                                                <input type="button" value="Add {@name}" onclick="addArrayItem(event)"></input>
                                                <input type="button" value="Remove {@name}" onclick="removeArrayItem(event)" disabled="disabled"></input>
                                            </xsl:if>
                                        </td>
                                    </xsl:when>
                                    <xsl:when test="enumeration">
                                        <td class="label">
                                            <xsl:value-of select="@name"/>
                                        </td>
                                        <td class="param">
                                            <select id="input_{$name}_{@name}_0">
                                                <xsl:for-each select="enumeration">
                                                    <option value="{@value}"><xsl:value-of select="@value"/></option>
                                                </xsl:for-each>
                                            </select>
                                        </td>    
                                    </xsl:when>
                                    <xsl:otherwise>
                                        <xsl:variable name="prefix">
                                            <xsl:if test="@type-namespace = 'http://www.w3.org/2001/XMLSchema'">xs:</xsl:if>
                                        </xsl:variable>
                                        <td class="label">
                                            <xsl:value-of select="@name"/>
                                            <xsl:if test="@minOccurs &lt; 1 or @maxOccurs &gt; 1 or @maxOccurs = 'unbounded'"><sub>(<xsl:value-of select="@minOccurs"/>..<xsl:choose><xsl:when test="@maxOccurs = 'unbounded'">*</xsl:when><xsl:otherwise><xsl:value-of select="@maxOccurs"/></xsl:otherwise></xsl:choose>)</sub></xsl:if></td>
                                        <td class="param">
                                            <div id="arrayparams_{$name}_{@name}">
                                                <!-- hidden template for additional array items -->
                                                <div style="display:none">
                                                    <textarea id="input_{$name}_{@name}_" class="emptyfield" onfocus="prepareInput(event)" onblur="restoreInput(event,'({$prefix}{@type})')" title="An {$prefix}{@type} value representing the {@name}">(<xsl:value-of select="$prefix"/><xsl:value-of select="@type"/>)</textarea>
                                                    <img src="{$image-path}expand.gif" class="cornerExpand" onclick="expand(event)" title="Increase typing space"/>
                                                </div>
                                                <div>
                                                    <textarea id="input_{$name}_{@name}_0" class="emptyfield" onfocus="prepareInput(event)" onblur="restoreInput(event,'({$prefix}{@type})')" title="An {$prefix}{@type} value representing the {@name}">(<xsl:value-of select="$prefix"/><xsl:value-of select="@type"/>)</textarea>
                                                    <img src="{$image-path}expand.gif" class="cornerExpand" onclick="expand(event)" title="Increase typing space"/>
                                                </div>
                                            </div>
                                            <xsl:if test="@maxOccurs &gt; 1 or @maxOccurs = 'unbounded'">
                                                <input type="button" value="Add {@name}" onclick="addArrayItem(event)"></input>
                                                <input type="button" value="Remove {@name}" onclick="removeArrayItem(event)" disabled="disabled"></input>
                                            </xsl:if>
                                        </td>    
                                    </xsl:otherwise>
                                </xsl:choose>
                            </tr>
                        </xsl:for-each>
                        <tr>
                            <td>
                                <input type="button" id="button_{$name}" value="{$name} >>" onclick="do_{$name}()" title="Invoke the {$name} operation"></input>
                            </td>
                            <td>
                                <div id="console_{$name}" class="output">
                                    
                                </div>
                            </td>
                        </tr>
                    </table>
                </div>
            </xsl:for-each>
        </td>        
    </xsl:template>
    
    <xsl:template name="return-type">
        <xsl:text>/* </xsl:text>
        <xsl:if test="@maxOccurs = 'unbounded' or @maxOccurs > 1">array of </xsl:if>
        <xsl:call-template name="xml-name-to-javascript-name">
            <xsl:with-param name="name" select="@type"/>
        </xsl:call-template>
        <xsl:text>*/</xsl:text>
    </xsl:template>
    
    <xsl:template name="xml-name-to-javascript-name">
        <xsl:param name="name"/>
        <xsl:value-of select="translate($name,'.-','__')"/>
    </xsl:template>

</xsl:stylesheet>
