/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.registry;

import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.registry.core.exceptions.RegistryException;
import org.wso2.carbon.registry.info.stub.InfoAdminServiceStub;
import org.wso2.carbon.registry.info.stub.RegistryExceptionException;
import org.wso2.carbon.registry.info.stub.beans.xsd.CommentBean;
import org.wso2.carbon.registry.info.stub.beans.xsd.EventTypeBean;
import org.wso2.carbon.registry.info.stub.beans.xsd.RatingBean;
import org.wso2.carbon.registry.info.stub.beans.xsd.SubscriptionBean;
import org.wso2.carbon.registry.info.stub.beans.xsd.TagBean;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class InfoServiceAdminClient {
    private static final Log log = LogFactory.getLog(InfoServiceAdminClient.class);
    private InfoAdminServiceStub infoAdminServiceStub;

    public InfoServiceAdminClient(String backEndUrl, String sessionCookie) throws RegistryException, AxisFault {
        String serviceName = "InfoAdminService";
        String endPoint = backEndUrl + serviceName;
        try {
            this.infoAdminServiceStub = new InfoAdminServiceStub(endPoint);
            AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.infoAdminServiceStub);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("infoAdminServiceStub Initialization fail " + axisFault.getMessage()));
            throw new AxisFault("infoAdminServiceStub Initialization fail " + axisFault.getMessage());
        }
    }

    public InfoServiceAdminClient(String backEndUrl, String userName, String password) throws RegistryException, AxisFault {
        String serviceName = "InfoAdminService";
        String endPoint = backEndUrl + serviceName;
        try {
            this.infoAdminServiceStub = new InfoAdminServiceStub(endPoint);
            AuthenticateStub.authenticateStub(userName, password, (Stub)this.infoAdminServiceStub);
        }
        catch (AxisFault axisFault) {
            log.error((Object)("infoAdminServiceStub Initialization fail " + axisFault.getMessage()));
            throw new AxisFault("infoAdminServiceStub Initialization fail " + axisFault.getMessage());
        }
    }

    public SubscriptionBean subscribe(String path, String endpoint, String eventName, String sessionId) throws RemoteException {
        SubscriptionBean bean = null;
        try {
            bean = this.infoAdminServiceStub.subscribe(path, endpoint, eventName, sessionId);
        }
        catch (RemoteException remoteException) {
            log.error((Object)("infoAdminServiceStub subscription fail " + remoteException.getMessage()));
            throw new RemoteException("infoAdminServiceStub subscription fail " + remoteException.getMessage());
        }
        catch (RegistryExceptionException registryException) {
            log.error((Object)("infoAdminServiceStub subscription fail " + registryException.getMessage()));
            throw new AxisFault("infoAdminServiceStub subscription fail " + registryException.getMessage());
        }
        return bean;
    }

    public void addComment(String comment, String path, String sessionId) throws RegistryException, AxisFault {
        try {
            this.infoAdminServiceStub.addComment(comment, path, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to add comment to resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to add comment to resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public void addTag(String tag, String path, String sessionId) throws RegistryException, AxisFault {
        try {
            this.infoAdminServiceStub.addTag(tag, path, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to add tag to resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to add tag to resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
    }

    public void rateResource(String rating, String path, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            this.infoAdminServiceStub.rateResource(rating, path, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to rate resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to rate resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public CommentBean getComments(String path, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            return this.infoAdminServiceStub.getComments(path, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to get comments of path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to rate comments of path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public RatingBean getRatings(String path, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            return this.infoAdminServiceStub.getRatings(path, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to get ratings of resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to get ratings of resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public TagBean getTags(String path, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            return this.infoAdminServiceStub.getTags(path, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to get tags of resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to get tags of resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public EventTypeBean getEventTypes(String path, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            return this.infoAdminServiceStub.getEventTypes(path, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to get events types of resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to get event types of resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public String getRemoteURL(String path, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            return this.infoAdminServiceStub.getRemoteURL(path, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to get remote URL of resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to get remote URL of resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public SubscriptionBean getSubscriptions(String path, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            return this.infoAdminServiceStub.getSubscriptions(path, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to get subscriptions of resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to get subscriptions of resource path - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public boolean isProfileExisting(String userName, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            return this.infoAdminServiceStub.isProfileExisting(userName, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to check profiles of - " + userName;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to check profiles of - " + userName;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public boolean isResource(String path, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            return this.infoAdminServiceStub.isResource(path, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to check resource - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to check resource - " + path;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public boolean isRoleProfileExisting(String role, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            return this.infoAdminServiceStub.isRoleProfileExisting(role, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to check role profile of - " + role;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to check role profile of - " + role;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public boolean isRoleValid(String role, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            return this.infoAdminServiceStub.isRoleValid(role, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to check validity of role - " + role;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to check validity of role - " + role;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public boolean isUserValid(String userName, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            return this.infoAdminServiceStub.isUserValid(userName, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to check validity of user - " + userName;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to check validity of user - " + userName;
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public void removeComment(String commentPath, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            this.infoAdminServiceStub.removeComment(commentPath, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to remove comment";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to remove comment  ";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public void removeTag(String tag, String path, String sessionId) throws RegistryException, RegistryExceptionException {
        try {
            this.infoAdminServiceStub.removeTag(tag, path, sessionId);
        }
        catch (RemoteException e) {
            String msg = "Unable to remove tag";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryException(msg, (Throwable)e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to remove tag  ";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }

    public void unsubscribe(String path, String subscriptionId, String sessionID) throws RemoteException, RegistryExceptionException {
        try {
            this.infoAdminServiceStub.unsubscribe(path, subscriptionId, sessionID);
        }
        catch (RemoteException e) {
            String msg = "Unable to unsubscribe";
            log.error((Object)msg, (Throwable)e);
            throw new RemoteException(msg, e);
        }
        catch (RegistryExceptionException e) {
            String msg = "Unable to unsubscribe";
            log.error((Object)msg, (Throwable)e);
            throw new RegistryExceptionException(msg, (Throwable)e);
        }
    }
}

