/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.clients.rest.api;

import java.rmi.RemoteException;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Stub;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.rest.api.stub.RestApiAdminAPIException;
import org.wso2.carbon.rest.api.stub.RestApiAdminStub;
import org.wso2.carbon.rest.api.stub.types.carbon.APIData;
import org.wso2.carbon.rest.api.stub.types.carbon.ResourceData;
import org.wso2.esb.integration.common.clients.client.utils.AuthenticateStub;

public class RestApiAdminClient {
    private static final Log log = LogFactory.getLog(RestApiAdminClient.class);
    private final String serviceName = "RestApiAdmin";
    private RestApiAdminStub restApiAdminStub;

    public RestApiAdminClient(String backEndUrl, String sessionCookie) throws AxisFault {
        String endPoint = backEndUrl + "RestApiAdmin";
        this.restApiAdminStub = new RestApiAdminStub(endPoint);
        AuthenticateStub.authenticateStub(sessionCookie, (Stub)this.restApiAdminStub);
    }

    public RestApiAdminClient(String backEndUrl, String userName, String password) throws AxisFault {
        String endPoint = backEndUrl + "RestApiAdmin";
        this.restApiAdminStub = new RestApiAdminStub(endPoint);
        AuthenticateStub.authenticateStub(userName, password, (Stub)this.restApiAdminStub);
    }

    public boolean add(OMElement apiData) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.addApiFromString(apiData.toString());
    }

    public boolean deleteApi(String apiName) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.deleteApi(apiName);
    }

    public boolean deleteApiForTenant(String apiName, String tenant) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.deleteApiForTenant(apiName, tenant);
    }

    public String[] getApiNames() throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.getApiNames();
    }

    public String getServerContext() throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.getServerContext();
    }

    public boolean addAPI(APIData apiData) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.addApi(apiData);
    }

    public boolean addAPIFromTenant(String apiData, String tenantDomain) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.addApiForTenant(apiData, tenantDomain);
    }

    public APIData getAPIbyName(String apiName) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.getApiByName(apiName);
    }

    public APIData getAPIForTenantByName(String apiName, String tenantDomain) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.getApiForTenant(apiName, tenantDomain);
    }

    public boolean updateAPIFromString(String apiName, String updateData) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.updateApiFromString(apiName, updateData);
    }

    public boolean updateAPIFromAPIData(String apiName, APIData apiData) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.updateApi(apiName, apiData);
    }

    public boolean updateAPIForTenant(String apiName, String updateData, String tenant) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.updateApiForTenant(apiName, updateData, tenant);
    }

    public void deleteAllApis() throws RestApiAdminAPIException, RemoteException {
        this.restApiAdminStub.deleteAllApi();
    }

    public int getAPICount() throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.getAPICount();
    }

    public String getAPISource(APIData apiData) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.getApiSource(apiData);
    }

    public String[] getAPISequences() throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.getSequences();
    }

    public String enableStatisticsForAPI(String apiName) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.enableStatistics(apiName);
    }

    public String disableStatisticsForAPI(String apiName) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.disableStatistics(apiName);
    }

    public String enableTracingForAPI(String apiName) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.enableTracing(apiName);
    }

    public String disableTracingForAPI(String apiName) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.disableTracing(apiName);
    }

    public APIData[] getAPIList(int page, int count) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.getAPIsForListing(page, count);
    }

    public String getAPIResource(ResourceData resourceData) throws RestApiAdminAPIException, RemoteException {
        return this.restApiAdminStub.getResourceSource(resourceData);
    }
}

