/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.coordination;

import com.moandjiezana.toml.Toml;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.extensions.ExecutionListenerExtension;

public class CoordinationDatabase
extends ExecutionListenerExtension {
    private static final Log logger = LogFactory.getLog(CoordinationDatabase.class);
    private String dbName;
    private String scriptPath;
    private static String connectionUrl;
    private static String pwd;
    private static String userName;
    private String dbType;
    private String dataSource;

    public void initiate() throws AutomationFrameworkException {
        logger.info((Object)"Initializing coordination database.");
        this.populateParameters();
    }

    public void onExecutionStart() throws AutomationFrameworkException {
        if (!"mysql".equals(this.dbType)) {
            logger.info((Object)"Database will be created only for mysql..");
            return;
        }
        String dbUrl = connectionUrl.replace("/" + this.dbName, "").concat("&allowMultiQueries=true");
        this.scriptPath = CoordinationDatabase.getSystemDependentPath(this.scriptPath);
        File file = new File(this.scriptPath);
        try {
            ArrayList<String> schema = new ArrayList<String>();
            schema.add("drop database if exists " + this.dbName + ";");
            schema.add("create database " + this.dbName + " character set latin1;");
            schema.add("use " + this.dbName + ";");
            schema.add(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8));
            try (Connection conn = DriverManager.getConnection(dbUrl, userName, pwd);
                 PreparedStatement preparedStatement = conn.prepareStatement(String.join((CharSequence)"", schema));){
                preparedStatement.executeUpdate();
            }
            logger.info((Object)"Coordination database configured successfully.");
        }
        catch (Exception ex) {
            throw new AutomationFrameworkException((Throwable)ex);
        }
    }

    public void onExecutionFinish() {
    }

    private static String getSystemDependentPath(String path) {
        return path.replace('/', File.separatorChar);
    }

    private void populateParameters() throws AutomationFrameworkException {
        Map parameters = this.getParameters();
        block10: for (Map.Entry entry : parameters.entrySet()) {
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            switch (key) {
                case "toml-path": {
                    this.parseToml(value);
                    continue block10;
                }
                case "script-path": {
                    this.scriptPath = value;
                    continue block10;
                }
                case "data-source": {
                    this.dataSource = value;
                    continue block10;
                }
            }
            logger.error((Object)("Unknown property : " + key));
        }
    }

    private void parseToml(String filePath) throws AutomationFrameworkException {
        File toml = new File(filePath);
        if (!toml.exists()) {
            throw new AutomationFrameworkException("File not found in : " + filePath);
        }
        try {
            Toml parseToml = new Toml().read(toml);
            String datasourceId = parseToml.getString("datasource[0].id");
            if (Objects.nonNull(this.dataSource) && !this.dataSource.equals(datasourceId)) {
                throw new AutomationFrameworkException("Data source " + this.dataSource + " is not defined in toml or not added as first datasource.");
            }
            connectionUrl = parseToml.getString("datasource[0].url").replaceAll("amp;", "");
            userName = parseToml.getString("datasource[0].username");
            pwd = parseToml.getString("datasource[0].password");
            URI uri = URI.create(connectionUrl.substring(5));
            String path = uri.getPath();
            if (path != null) {
                this.dbName = path.replace("/", "");
            }
            this.dbType = uri.getScheme();
        }
        catch (Exception ex) {
            throw new AutomationFrameworkException((Throwable)ex);
        }
    }

    public static String getConnectionUrl() {
        return connectionUrl;
    }

    public static String getUserName() {
        return userName;
    }

    public static String getPwd() {
        return pwd;
    }
}

