/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.extensions.carbonserver;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.engine.context.AutomationContext;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.carbon.automation.engine.frameworkutils.FrameworkPathUtil;
import org.wso2.esb.integration.common.extensions.carbonserver.CarbonServerManager;
import org.wso2.esb.integration.common.extensions.carbonserver.ServerUtils;

public class TestServerManager {
    private static final Log log = LogFactory.getLog(TestServerManager.class);
    private CarbonServerManager carbonServer;
    private String carbonZip;
    private int portOffset;
    private Map<String, String> commandMap;
    protected String carbonHome;

    TestServerManager(AutomationContext context, String carbonZip, Map<String, String> commandMap) {
        this.carbonServer = new CarbonServerManager(context);
        this.carbonZip = carbonZip;
        if (commandMap.get("-DportOffset") == null) {
            throw new IllegalArgumentException("portOffset value must be set in command list");
        }
        this.portOffset = Integer.parseInt(commandMap.get("-DportOffset"));
        this.commandMap = commandMap;
    }

    public String getCarbonHome() {
        return this.carbonHome;
    }

    private void configureServer(String deploymentDirectory, String registryDir) throws IOException {
        if ("ESB".equalsIgnoreCase(System.getProperty("server.list"))) {
            ServerUtils.copyResources("ESB", this.getCarbonHome(), deploymentDirectory, registryDir);
            String resourceHome = FrameworkPathUtil.getSystemResourceLocation() + File.separator + "artifacts" + File.separator + "ESB" + File.separator + "server";
            File dropinsDirectorySource = new File(resourceHome + File.separator + "dropins");
            File dropinsDestination = new File(this.getCarbonHome() + File.separator + "dropins");
            if (dropinsDirectorySource.exists() && dropinsDirectorySource.isDirectory()) {
                try {
                    log.info((Object)("Copying " + dropinsDirectorySource.getPath() + " to " + dropinsDestination.getPath()));
                    FileUtils.copyDirectory((File)dropinsDirectorySource, (File)dropinsDestination);
                }
                catch (IOException e) {
                    log.error((Object)"Error while copying lib directory.", (Throwable)e);
                }
            }
        } else if ("DSS".equalsIgnoreCase(System.getProperty("server.list"))) {
            ServerUtils.copyResources("DSS", this.getCarbonHome(), deploymentDirectory, registryDir);
        }
    }

    public Map<String, String> getCommands() {
        return this.commandMap;
    }

    public String startServer() throws AutomationFrameworkException, IOException {
        return this.startServer(null, null);
    }

    public String startServer(String deploymentDirectory, String registryDir) throws AutomationFrameworkException, IOException {
        if (this.carbonHome == null) {
            this.setUpCarbonHome(deploymentDirectory, registryDir);
        }
        log.info((Object)("Carbon Home - " + this.carbonHome));
        this.portOffset = this.commandMap.get("-DportOffset") != null ? Integer.parseInt(this.commandMap.get("-DportOffset")) : 0;
        this.carbonServer.startServerUsingCarbonHome(this.carbonHome, this.commandMap);
        return this.carbonHome;
    }

    private void setUpCarbonHome(String deploymentDirectory, String registryDir) throws IOException, AutomationFrameworkException {
        if (this.carbonZip == null) {
            this.carbonZip = System.getProperty("carbon.zip");
        }
        if (this.carbonZip == null) {
            throw new IllegalArgumentException("carbon zip file cannot find in the given location");
        }
        this.carbonHome = this.carbonServer.setUpCarbonHome(this.carbonZip, this.commandMap.get("startupScript"));
        this.configureServer(deploymentDirectory, registryDir);
    }

    public void restartGracefully() throws AutomationFrameworkException {
        if (this.carbonHome == null) {
            throw new AutomationFrameworkException("No Running Server found to restart. Please make sure whether server is started");
        }
        this.carbonServer.restartGracefully();
    }

    public void stopServer() throws AutomationFrameworkException {
        this.carbonServer.serverShutdown(this.portOffset, false);
    }

    void restartServer() throws AutomationFrameworkException {
        log.info((Object)"Preparing to restart the server ...");
        this.carbonServer.serverShutdown(this.portOffset, true);
        this.carbonServer.startServerUsingCarbonHome(this.carbonHome, this.commandMap);
        log.info((Object)"Server restarted successfully ...");
    }

    void restartServer(Map<String, String> commands) throws AutomationFrameworkException {
        log.info((Object)"Preparing to restart the server ...");
        this.commandMap.putAll(commands);
        this.carbonServer.serverShutdown(this.portOffset, true);
        this.carbonServer.startServerUsingCarbonHome(this.carbonHome, this.commandMap);
        log.info((Object)"Server restarted successfully ...");
    }

    void startMIServer() throws AutomationFrameworkException {
        log.info((Object)"Preparing to start the MI server ...");
        this.carbonServer.startServerUsingCarbonHome(this.carbonHome, this.commandMap);
        log.info((Object)"Server restarted successfully ...");
    }
}

