/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dataservices.samples;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ConfigurationContextFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyEngine;
import org.wso2.carbon.dataservices.samples.BaseSample;
import org.wso2.carbon.dataservices.samples.secure_dataservice.SecureDataServiceStub;
import org.wso2.ws.dataservice.samples.secure_dataservice.Office;

public class SecureSample
extends BaseSample {
    private static Policy loadPolicy(String path) throws Exception {
        FileInputStream resource = new FileInputStream(path);
        StAXOMBuilder builder = new StAXOMBuilder((InputStream)resource);
        return PolicyEngine.getPolicy((OMElement)builder.getDocumentElement());
    }

    public static void main(String[] args) throws Exception {
        Office[] offices;
        String epr = "https://" + HOST_IP + ":" + HOST_HTTPS_PORT + "/services/samples/SecureDataService";
        System.setProperty("javax.net.ssl.trustStore", new File(CLIENT_JKS_PATH).getAbsolutePath());
        ConfigurationContext ctx = ConfigurationContextFactory.createConfigurationContextFromFileSystem(null, null);
        SecureDataServiceStub stub = new SecureDataServiceStub(ctx, epr);
        ServiceClient client = stub._getServiceClient();
        Options options = client.getOptions();
        client.engageModule("rampart");
        options.setUserName("admin");
        options.setPassword("admin");
        options.setProperty("rampartPolicy", (Object)SecureSample.loadPolicy(SECURITY_POLICY_PATH));
        for (Office office : offices = stub.showAllOffices()) {
            System.out.println("\t-----------------------------");
            System.out.println("\tOffice Code: " + office.getOfficeCode());
            System.out.println("\tPhone: " + office.getPhone());
            System.out.println("\tAddress Line 1: " + office.getAddressLine1());
            System.out.println("\tAddress Line 2: " + office.getAddressLine2());
            System.out.println("\tCity: " + office.getCity());
            System.out.println("\tState: " + office.getState());
            System.out.println("\tPostal Code: " + office.getPostalCode());
            System.out.println("\tCountry: " + office.getCountry());
        }
    }
}

