/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.awaitility.Awaitility;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.esb.integration.common.utils.ESBIntegrationTest;
import org.wso2.esb.integration.common.utils.clients.SimpleHttpClient;
import org.wso2.micro.integrator.api.TokenUtil;

public class MessageStoreResourceTestCase
extends ESBIntegrationTest {
    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
    }

    @Test(groups={"wso2.esb"}, description="Test get Message Stores resource")
    public void retrieveMessageStores() throws IOException {
        String responsePayload = this.sendHttpRequestAndGetPayload(null);
        JSONObject jsonResponse = new JSONObject(responsePayload);
        Assert.assertEquals((Object)jsonResponse.get("count"), (Object)3, (String)"Assert Failed due to the mismatch of actual vs expected resource count");
        Assert.assertTrue((boolean)jsonResponse.get("list").toString().contains("AbcMessageStore"));
        Assert.assertTrue((boolean)jsonResponse.get("list").toString().contains("HelloMessageStore"));
        Assert.assertTrue((boolean)jsonResponse.get("list").toString().contains("teststore"));
    }

    @Test(groups={"wso2.esb"}, description="Test get Message Stores resource for search key")
    public void retrieveSearchedMessageStores() throws IOException {
        String responsePayload = this.sendHttpRequestAndGetPayload("HelloMessage");
        JSONObject jsonResponse = new JSONObject(responsePayload);
        Assert.assertEquals((Object)jsonResponse.get("count"), (Object)1, (String)"Assert Failed due to the mismatch of actual vs expected resource count");
        Assert.assertTrue((boolean)jsonResponse.get("list").toString().contains("HelloMessageStore"));
    }

    private String sendHttpRequestAndGetPayload(String searchKey) throws IOException {
        if (!this.isManagementApiAvailable) {
            Awaitility.await().pollInterval(100L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
        }
        String accessToken = TokenUtil.getAccessToken(this.hostName, this.portOffset);
        Assert.assertNotNull((Object)accessToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Authorization", "Bearer " + accessToken);
        String endpoint = "https://" + this.hostName + ":" + (9154 + this.portOffset) + "/management/message-stores";
        if (searchKey != null) {
            endpoint = endpoint.concat("?searchKey=").concat(searchKey);
        }
        SimpleHttpClient client = new SimpleHttpClient();
        HttpResponse response = client.doGet(endpoint, headers);
        String responsePayload = client.getResponsePayload(response);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200);
        return responsePayload;
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

