/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.awaitility.Awaitility;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.esb.integration.common.extensions.carbonserver.CarbonTestServerManager;
import org.wso2.esb.integration.common.utils.ESBIntegrationTest;
import org.wso2.esb.integration.common.utils.clients.SimpleHttpClient;
import org.wso2.micro.integrator.api.TokenUtil;

public class ConfigsResourceTestCase
extends ESBIntegrationTest {
    private String carbonHome;
    private CarbonTestServerManager server;
    private int offset;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.offset = this.portOffset + 10;
    }

    @Test(groups={"wso2.esb"}, description="Test get configs resource for correlation")
    public void testRetrieveCorrelationConfigs() throws IOException, AutomationFrameworkException {
        this.startNewServer(false);
        this.getCorrelationLogStateAndAssert(this.offset, false);
        String apiLogFilePath = this.carbonHome + File.separator + "repository" + File.separator + "logs" + File.separator + "correlation.log";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(apiLogFilePath));
        String logLine = bufferedReader.readLine();
        Assert.assertNull((Object)logLine);
    }

    @Test(groups={"wso2.esb"}, dependsOnMethods={"testRetrieveCorrelationConfigs"}, description="Test put configs resource for correlation")
    public void testUpdateCorrelationConfigsEnable() throws IOException {
        this.updateCorrelationLogState(this.offset, true);
        this.getCorrelationLogStateAndAssert(this.offset, true);
        String apiLogFilePath = this.carbonHome + File.separator + "repository" + File.separator + "logs" + File.separator + "correlation.log";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(apiLogFilePath));
        String logLine = bufferedReader.readLine();
        Assert.assertNotNull((Object)logLine);
        while ((logLine = bufferedReader.readLine()) != null) {
            Assert.assertTrue((logLine.contains("HTTP State Transition") || logLine.contains("ROUND-TRIP LATENCY") || logLine.contains("Thread switch latency") ? 1 : 0) != 0);
        }
    }

    @Test(groups={"wso2.esb"}, dependsOnMethods={"testUpdateCorrelationConfigsEnable"}, description="Test put configs resource for correlation")
    public void testUpdateCorrelationConfigsDisable() throws IOException {
        this.updateCorrelationLogState(this.offset, false);
        String apiLogFilePath = this.carbonHome + File.separator + "repository" + File.separator + "logs" + File.separator + "correlation.log";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(apiLogFilePath));
        String logLine = bufferedReader.readLine();
        Assert.assertNotNull((Object)logLine);
        while ((logLine = bufferedReader.readLine()) != null) {
            Assert.assertTrue((logLine.contains("HTTP State Transition") || logLine.contains("ROUND-TRIP LATENCY") || logLine.contains("Thread switch latency") ? 1 : 0) != 0);
        }
        this.getCorrelationLogStateAndAssert(this.offset, false);
        logLine = bufferedReader.readLine();
        Assert.assertNull((Object)logLine);
    }

    @Test(groups={"wso2.esb"}, dependsOnMethods={"testUpdateCorrelationConfigsDisable"}, description="Test put configs resource for correlation")
    public void testUpdateCorrelationConfigsRandom() throws IOException {
        this.updateCorrelationLogState(this.offset, true);
        this.getCorrelationLogStateAndAssert(this.offset, true);
        String accessToken = TokenUtil.getAccessToken(this.hostName, this.offset);
        Assert.assertNotNull((Object)accessToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Authorization", "Bearer " + accessToken);
        String endpoint = "https://" + this.hostName + ":" + (9154 + this.offset) + "/management/configs";
        JSONObject payloadConfigs = new JSONObject();
        payloadConfigs.put("enabled", (Object)"abcd");
        JSONObject payload = new JSONObject();
        payload.put("configName", (Object)"correlation");
        payload.put("configs", (Object)payloadConfigs);
        SimpleHttpClient client = new SimpleHttpClient();
        HttpResponse response = client.doPut(endpoint, headers, payload.toString(), "application/json");
        String responsePayload = client.getResponsePayload(response);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200);
        JSONObject jsonResponse = new JSONObject(responsePayload);
        Assert.assertTrue((boolean)jsonResponse.has("message"));
        Assert.assertEquals((Object)jsonResponse.get("message"), (Object)"Successfully Updated Correlation Logs Status");
        this.getCorrelationLogStateAndAssert(this.offset, false);
    }

    @Test(groups={"wso2.esb"}, dependsOnMethods={"testUpdateCorrelationConfigsRandom"}, description="Test get configs resource for correlation with system parameter")
    public void testRetrieveCorrelationConfigsWithSystemParameter() throws IOException, AutomationFrameworkException {
        this.stopServer();
        this.startNewServer(true);
        this.getCorrelationLogStateAndAssert(this.offset, true);
        this.updateCorrelationLogState(this.offset, false);
        String apiLogFilePath = this.carbonHome + File.separator + "repository" + File.separator + "logs" + File.separator + "correlation.log";
        BufferedReader bufferedReader = new BufferedReader(new FileReader(apiLogFilePath));
        String logLine = bufferedReader.readLine();
        Assert.assertNotNull((Object)logLine);
        while ((logLine = bufferedReader.readLine()) != null) {
            Assert.assertTrue((logLine.contains("HTTP State Transition") || logLine.contains("ROUND-TRIP LATENCY") || logLine.contains("Thread switch latency") ? 1 : 0) != 0);
        }
        this.getCorrelationLogStateAndAssert(this.offset, true);
        while ((logLine = bufferedReader.readLine()) != null) {
            Assert.assertTrue((logLine.contains("HTTP State Transition") || logLine.contains("ROUND-TRIP LATENCY") || logLine.contains("Thread switch latency") ? 1 : 0) != 0);
        }
    }

    private void startNewServer(boolean enableCorrelationLogs) throws IOException, AutomationFrameworkException {
        HashMap<String, String> startupParameterMap = new HashMap<String, String>();
        startupParameterMap.put("-DportOffset", String.valueOf(this.offset));
        startupParameterMap.put("-DenableCorrelationLogs", String.valueOf(enableCorrelationLogs));
        startupParameterMap.put("startupScript", "micro-integrator");
        this.server = new CarbonTestServerManager(this.context, System.getProperty("carbon.zip"), startupParameterMap);
        this.server.startServer();
        Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
        this.carbonHome = this.server.getCarbonHome();
        Assert.assertNotNull((Object)this.carbonHome);
    }

    private void stopServer() throws AutomationFrameworkException {
        this.server.stopServer();
    }

    private void getCorrelationLogStateAndAssert(int offset, boolean correlationConfigStatus) throws IOException {
        String accessToken = TokenUtil.getAccessToken(this.hostName, offset);
        Assert.assertNotNull((Object)accessToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Authorization", "Bearer " + accessToken);
        String endpoint = "https://" + this.hostName + ":" + (9154 + offset) + "/management/configs?configName=correlation";
        SimpleHttpClient client = new SimpleHttpClient();
        HttpResponse response = client.doGet(endpoint, headers);
        String responsePayload = client.getResponsePayload(response);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200);
        JSONObject jsonResponse = new JSONObject(responsePayload);
        Assert.assertTrue((boolean)jsonResponse.has("configName"));
        Assert.assertEquals((Object)jsonResponse.get("configName"), (Object)"correlation");
        Assert.assertTrue((boolean)jsonResponse.has("configs"));
        JSONObject responseConfigs = (JSONObject)jsonResponse.get("configs");
        Assert.assertTrue((boolean)responseConfigs.has("enabled"));
        Assert.assertEquals((Object)responseConfigs.get("enabled"), (Object)correlationConfigStatus);
    }

    private void updateCorrelationLogState(int offset, boolean correlationConfigEnabled) throws IOException {
        String accessToken = TokenUtil.getAccessToken(this.hostName, offset);
        Assert.assertNotNull((Object)accessToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Authorization", "Bearer " + accessToken);
        String endpoint = "https://" + this.hostName + ":" + (9154 + offset) + "/management/configs";
        JSONObject payloadConfigs = new JSONObject();
        payloadConfigs.put("enabled", correlationConfigEnabled);
        JSONObject payload = new JSONObject();
        payload.put("configName", (Object)"correlation");
        payload.put("configs", (Object)payloadConfigs);
        SimpleHttpClient client = new SimpleHttpClient();
        HttpResponse response = client.doPut(endpoint, headers, payload.toString(), "application/json");
        String responsePayload = client.getResponsePayload(response);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200);
        JSONObject jsonResponse = new JSONObject(responsePayload);
        Assert.assertTrue((boolean)jsonResponse.has("message"));
        Assert.assertEquals((Object)jsonResponse.get("message"), (Object)"Successfully Updated Correlation Logs Status");
    }

    public Callable<Boolean> isManagementApiAvailable() {
        return this::checkIfManagementApiAvailable;
    }

    private boolean checkIfManagementApiAvailable() {
        boolean bl;
        Socket socket = new Socket(this.hostName, 9154 + this.offset);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        this.stopServer();
        System.setProperty("port.offset", String.valueOf(this.portOffset));
        System.setProperty("enableCorrelationLogs", "false");
        super.cleanup();
    }
}

