/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class DataServiceResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "data-services";

    @Test(groups={"wso2.esb"}, description="Test get Data Services resource")
    public void retrieveDataServices() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyResourceCount(jsonResponse, 2);
        this.verifyResourceInfo(jsonResponse, new String[]{"AbcDataService", "HelloDataService"});
    }

    @Test(groups={"wso2.esb"}, description="Test get Data Services resource for search key")
    public void retrieveSearchedDataServices() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=Hello"));
        this.verifyResourceCount(jsonResponse, 1);
        this.verifyResourceInfo(jsonResponse, new String[]{"HelloDataService"});
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

