/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class EndpointResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "endpoints";

    @Test(groups={"wso2.esb"}, description="Test get Endpoint resource")
    public void retrieveEndpoints() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyResourceCount(jsonResponse, 3);
        this.verifyResourceInfo(jsonResponse, new String[]{"AbcEndPoint", "HelloEndPoint"});
    }

    @Test(groups={"wso2.esb"}, description="Test get Endpoints resource for search key")
    public void retrieveSearchedEndpoints() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=HelloEndPoint"));
        this.verifyResourceCount(jsonResponse, 1);
        this.verifyResourceInfo(jsonResponse, new String[]{"HelloEndPoint"});
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

