/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class LogConfigsResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "logging";

    @Test(groups={"wso2.esb"}, description="Test get Log Configs resource")
    public void retrieveLogConfigs() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyResourceCount(jsonResponse, 80);
        this.verifyResourceInfo(jsonResponse, new String[]{"axis2Deployment", "Axis2SynapseController"});
    }

    @Test(groups={"wso2.esb"}, description="Test get Log Configs resource for search key")
    public void retrieveSearchedLogConfigs() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=audit"));
        this.verifyResourceCount(jsonResponse, 1);
        this.verifyResourceInfo(jsonResponse, new String[]{"AUDIT_LOG"});
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

