/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.http.HttpResponse;
import org.awaitility.Awaitility;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeSuite;
import org.wso2.esb.integration.common.utils.ESBIntegrationTest;
import org.wso2.esb.integration.common.utils.clients.SimpleHttpClient;
import org.wso2.micro.integrator.api.TokenUtil;

public abstract class ManagementAPITest
extends ESBIntegrationTest {
    protected static final String LIST = "list";
    protected static final String COUNT = "count";
    protected static String accessToken;
    private static String endpoint;

    @BeforeSuite
    public void setEnvironment() throws Exception {
        super.init();
        accessToken = TokenUtil.getAccessToken(this.hostName, this.portOffset);
        endpoint = "https://" + this.hostName + ":" + (9154 + this.portOffset) + "/management/";
    }

    @BeforeClass
    protected void init() throws Exception {
        super.init();
    }

    protected JSONObject sendHttpRequestAndGetPayload(String resourcePath) throws IOException {
        if (!this.isManagementApiAvailable) {
            Awaitility.await().pollInterval(100L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
        }
        Assert.assertNotNull((Object)accessToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Authorization", "Bearer " + accessToken);
        SimpleHttpClient client = new SimpleHttpClient();
        HttpResponse response = client.doGet(endpoint.concat(resourcePath), headers);
        String responsePayload = client.getResponsePayload(response);
        Assert.assertEquals((int)response.getStatusLine().getStatusCode(), (int)200);
        JSONObject jsonResponse = new JSONObject(responsePayload);
        return jsonResponse;
    }

    protected void verifyResourceCount(JSONObject jsonResponse, int expectedCount) {
        Assert.assertEquals((Object)jsonResponse.get(COUNT), (Object)expectedCount, (String)"Assert Failed due to the mismatch of actual vs expected resource count");
    }

    protected void verifyResourceInfo(JSONObject jsonResponse, String[] expectedResourceNames) {
        for (String expectedResourceName : expectedResourceNames) {
            Assert.assertTrue((boolean)jsonResponse.get(LIST).toString().contains(expectedResourceName), (String)"Assert failed since expected resource name not found in the list");
        }
    }
}

