/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.awaitility.Awaitility;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.exceptions.AutomationFrameworkException;
import org.wso2.esb.integration.common.extensions.carbonserver.CarbonTestServerManager;
import org.wso2.esb.integration.common.utils.CarbonLogReader;
import org.wso2.esb.integration.common.utils.ESBIntegrationTest;
import org.wso2.esb.integration.common.utils.clients.SimpleHttpClient;
import org.wso2.micro.integrator.api.TokenUtil;

public class MetaDataResourceTestCase
extends ESBIntegrationTest {
    private String carbonHome;
    private int offset;

    @BeforeClass(alwaysRun=true)
    public void setEnvironment() throws Exception {
        super.init();
        this.offset = this.portOffset + 10;
    }

    @Test(groups={"wso2.esb"}, description="Test restart operation")
    public void testRestart() throws IOException, InterruptedException, AutomationFrameworkException {
        this.startNewServer();
        CarbonLogReader carbonLogReader = new CarbonLogReader(this.getCarbonHome());
        carbonLogReader.start();
        this.sendPatchRequest("restart");
        Assert.assertTrue((boolean)carbonLogReader.checkForLog("Restarting WSO2 Micro Integrator", 120));
        Assert.assertTrue((boolean)carbonLogReader.checkForLog("WSO2 Micro Integrator started in", 120));
        Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
    }

    @Test(groups={"wso2.esb"}, dependsOnMethods={"testRestart"}, description="Test shutdown operation")
    public void testShutdown() throws IOException, InterruptedException, AutomationFrameworkException {
        CarbonLogReader carbonLogReader = new CarbonLogReader(this.getCarbonHome());
        carbonLogReader.start();
        this.sendPatchRequest("shutdown");
        Assert.assertTrue((boolean)carbonLogReader.checkForLog("Shutting down the task manager", 120));
        Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiUnAvailable());
    }

    @Test(groups={"wso2.esb"}, dependsOnMethods={"testShutdown"}, description="Test gracefully shutdown operation")
    public void testRestartGracefully() throws IOException, InterruptedException, AutomationFrameworkException {
        this.startNewServer();
        CarbonLogReader carbonLogReader = new CarbonLogReader(this.getCarbonHome());
        carbonLogReader.start();
        this.sendPatchRequest("restartGracefully");
        Assert.assertTrue((boolean)carbonLogReader.checkForLog("Gracefully restarting WSO2 Micro Integrator", 120));
        Assert.assertTrue((boolean)carbonLogReader.checkForLog("Starting a new Carbon instance. Current instance will be shutdown", 120));
        Assert.assertTrue((boolean)carbonLogReader.checkForLog("WSO2 Micro Integrator started in", 120));
        Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
    }

    @Test(groups={"wso2.esb"}, dependsOnMethods={"testRestartGracefully"}, description="Test gracefully shutdown operation")
    public void testShutdownGracefully() throws IOException, InterruptedException {
        CarbonLogReader carbonLogReader = new CarbonLogReader(this.getCarbonHome());
        carbonLogReader.start();
        this.sendPatchRequest("shutdownGracefully");
        Assert.assertTrue((boolean)carbonLogReader.checkForLog("Gracefully shutting down WSO2 Micro Integrator", 120));
        Assert.assertTrue((boolean)carbonLogReader.checkForLog("Shutting down the task manager", 120));
        Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiUnAvailable());
    }

    private String getCarbonHome() {
        return this.carbonHome;
    }

    private void startNewServer() throws IOException, AutomationFrameworkException {
        HashMap<String, String> startupParameterMap = new HashMap<String, String>();
        startupParameterMap.put("-DportOffset", String.valueOf(this.offset));
        startupParameterMap.put("startupScript", "micro-integrator");
        CarbonTestServerManager server = new CarbonTestServerManager(this.context, System.getProperty("carbon.zip"), startupParameterMap);
        server.startServer();
        Awaitility.await().pollInterval(50L, TimeUnit.MILLISECONDS).atMost(60L, TimeUnit.SECONDS).until(this.isManagementApiAvailable());
        this.carbonHome = server.getCarbonHome();
        Assert.assertNotNull((Object)this.carbonHome);
    }

    public Callable<Boolean> isManagementApiAvailable() {
        return this::checkIfManagementApiAvailable;
    }

    public Callable<Boolean> isManagementApiUnAvailable() {
        return () -> !this.checkIfManagementApiAvailable();
    }

    private boolean checkIfManagementApiAvailable() {
        boolean bl;
        Socket socket = new Socket(this.hostName, 9154 + this.offset);
        try {
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    socket.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                return false;
            }
        }
        socket.close();
        return bl;
    }

    private void sendPatchRequest(String status) throws IOException {
        String accessToken = TokenUtil.getAccessToken(this.hostName, this.offset);
        Assert.assertNotNull((Object)accessToken);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        headers.put("Authorization", "Bearer " + accessToken);
        String endpoint = "https://" + this.hostName + ":" + (9154 + this.offset) + "/management/server";
        JSONObject payload = new JSONObject();
        payload.put("status", (Object)status);
        SimpleHttpClient client = new SimpleHttpClient();
        client.doPatch(endpoint, headers, payload.toString(), "application/json");
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
        System.setProperty("port.offset", String.valueOf(this.portOffset));
    }
}

