/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class ProxyServiceResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "proxy-services";

    @Test(groups={"wso2.esb"}, description="Test get Proxy Service resource")
    public void retrieveProxyServices() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyResourceCount(jsonResponse, 3);
        this.verifyResourceInfo(jsonResponse, new String[]{"AbcProxyService", "HelloProxyService", "testProxy"});
    }

    @Test(groups={"wso2.esb"}, description="Test get Proxy Service resource for search key")
    public void retrieveSearchedProxyServices() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=HelloProxy"));
        this.verifyResourceCount(jsonResponse, 1);
        this.verifyResourceInfo(jsonResponse, new String[]{"HelloProxyService"});
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

