/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class SequenceResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "sequences";

    @Test(groups={"wso2.esb"}, description="Test get Sequences resource")
    public void retrieveSequences() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyResourceCount(jsonResponse, 5);
        this.verifyResourceInfo(jsonResponse, new String[]{"AbcSequence", "fault", "main"});
    }

    @Test(groups={"wso2.esb"}, description="Test get Sequences resource for search key")
    public void retrieveSearchedSequences() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=ABC"));
        this.verifyResourceCount(jsonResponse, 1);
        this.verifyResourceInfo(jsonResponse, new String[]{"AbcSequence"});
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

