/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class ApiResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "apis";

    @Test(groups={"wso2.esb"}, description="Test get APIs resource")
    public void retrieveAPIs() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyResourceCount(jsonResponse, 4);
        this.verifyResourceInfo(jsonResponse, new String[]{"AbcRestApi", "HelloRestApi"});
    }

    @Test(groups={"wso2.esb"}, description="Test get APIs resource for search key")
    public void retrieveSearchedAPIs() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=HeLloRest"));
        this.verifyResourceCount(jsonResponse, 1);
        this.verifyResourceInfo(jsonResponse, new String[]{"HelloRestApi"});
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

