/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class CarbonAppResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "applications";
    private static final String ACTIVE_LIST = "activeList";
    private static final String FAULTY_LIST = "faultyList";
    private static final String TOTAL_COUNT = "totalCount";

    @Test(groups={"wso2.esb"}, description="Test get carbon applications resource")
    public void retrieveCApps() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyTotalResourceCount(jsonResponse, 4);
        this.verifyFaultyResourceInfo(jsonResponse, new String[]{"FaultyCAppCompositeExporter"});
        this.verifyActiveResourceInfo(jsonResponse, new String[]{"hello-worldCompositeExporter"});
    }

    @Test(groups={"wso2.esb"}, description="Test get carbon applications resource for search key")
    public void retrieveSearchedCApps() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=FaultyCApp"));
        this.verifyTotalResourceCount(jsonResponse, 1);
        this.verifyFaultyResourceInfo(jsonResponse, new String[]{"FaultyCAppCompositeExporter"});
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }

    protected void verifyTotalResourceCount(JSONObject jsonResponse, int expectedCount) {
        Assert.assertEquals((Object)jsonResponse.get(TOTAL_COUNT), (Object)expectedCount, (String)"Assert Failed due to the mismatch of actual vs expected resource count");
    }

    protected void verifyActiveResourceInfo(JSONObject jsonResponse, String[] expectedResourceNames) {
        for (String expectedResourceName : expectedResourceNames) {
            Assert.assertTrue((boolean)jsonResponse.get(ACTIVE_LIST).toString().contains(expectedResourceName), (String)"Assert failed since expected resource name not found in the list");
        }
    }

    protected void verifyFaultyResourceInfo(JSONObject jsonResponse, String[] expectedResourceNames) {
        for (String expectedResourceName : expectedResourceNames) {
            Assert.assertTrue((boolean)jsonResponse.get(FAULTY_LIST).toString().contains(expectedResourceName), (String)"Assert failed since expected resource name not found in the list");
        }
    }
}

