/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class ConnectorResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "connectors";

    @Test(groups={"wso2.esb"}, description="Test get Connectors resource")
    public void retrieveConnectors() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyResourceCount(jsonResponse, 2);
        this.verifyResourceInfo(jsonResponse, new String[]{"CSV"});
    }

    @Test(groups={"wso2.esb"}, description="Test get Connectors resource for search key")
    public void retrieveSearchedConnectors() throws IOException {
        this.verifyResourceCount(this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=csv")), 1);
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

