/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class DataSourceResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "data-sources";

    @Test(groups={"wso2.esb"}, description="Test get data source info")
    public void retrieveDataSourceInfo() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath.concat("?name=").concat("MySQLConnection2"));
        String datasourceType = jsonResponse.get("type").toString();
        Assert.assertEquals((String)datasourceType, (String)"RDBMS");
    }

    @Test(groups={"wso2.esb"}, description="Test get data-source resource for search key")
    public void retrieveSearchedDataSources() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=MYSQL"));
        this.verifyResourceCount(jsonResponse, 1);
        this.verifyResourceInfo(jsonResponse, new String[]{"MySQLConnection2"});
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

