/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class InboundEndpointResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "inbound-endpoints";

    @Test(groups={"wso2.esb"}, description="Test get Inbound Endpoints resource")
    public void retrieveInboundEPs() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyResourceCount(jsonResponse, 2);
        this.verifyResourceInfo(jsonResponse, new String[]{"HL7_Inbound", "testInboundEndpoint"});
    }

    @Test(groups={"wso2.esb"}, description="Test get Inbound Endpoints resource for search key")
    public void retrieveSearchedInboundEPs() throws IOException {
        this.verifyResourceCount(this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=HL7_")), 1);
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

