/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class LocalEntryResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "local-entries";

    @Test(groups={"wso2.esb"}, description="Test get Local Entries resource")
    public void retrieveLocalEntries() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyResourceCount(jsonResponse, 2);
        this.verifyResourceInfo(jsonResponse, new String[]{"AbcLocalEntry", "HelloLocalEntry"});
    }

    @Test(groups={"wso2.esb"}, description="Test get Local Entries resource for search key")
    public void retrieveSearchedLocalEntries() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=Hello"));
        this.verifyResourceCount(jsonResponse, -1);
        this.verifyResourceInfo(jsonResponse, new String[]{"HelloLocalEntry"});
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

