/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class LogFilesResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "logs";

    @Test(groups={"wso2.esb"}, description="Test get Logfiles resource")
    public void retrieveLogs() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyResourceCount(jsonResponse, 9);
        this.verifyResourceInfo(jsonResponse, new String[]{"wso2error.log", "wso2-mi-service.log"});
    }

    @Test(groups={"wso2.esb"}, description="Test get log file resource for search key")
    public void retrieveSearchedLogs() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=error"));
        this.verifyResourceCount(jsonResponse, 1);
        this.verifyResourceInfo(jsonResponse, new String[]{"wso2error.log"});
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

