/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class TaskResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "tasks";

    @Test(groups={"wso2.esb"}, description="Test get Tasks resource")
    public void retrieveTasks() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyResourceCount(jsonResponse, 1);
        this.verifyResourceInfo(jsonResponse, new String[]{"AbcScheduledTask"});
    }

    @Test(groups={"wso2.esb"}, description="Test get Tasks resource for search key")
    public void retrieveSearchedTasks() throws IOException {
        this.verifyResourceCount(this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=ABCd")), 0);
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

