/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.micro.integrator.api;

import java.io.IOException;
import org.json.JSONObject;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.wso2.micro.integrator.api.ManagementAPITest;

public class TemplatesResourceTestCase
extends ManagementAPITest {
    private static String resourcePath = "templates";

    @Test(groups={"wso2.esb"}, description="Test get Templates resource")
    public void retrieveTemplates() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath);
        this.verifyResourceCount(jsonResponse, 2);
        this.verifyResourceInfo(jsonResponse, new String[]{"AbcTemplate", "testSequenceTemplate"});
    }

    @Test(groups={"wso2.esb"}, description="Test get Templates resource for search key")
    public void retrieveSearchedTemplates() throws IOException {
        JSONObject jsonResponse = this.sendHttpRequestAndGetPayload(resourcePath.concat("?searchKey=Abc"));
        this.verifyResourceCount(jsonResponse, 1);
        this.verifyResourceInfo(jsonResponse, new String[]{"AbcTemplate"});
    }

    @AfterClass(alwaysRun=true)
    public void cleanState() throws Exception {
        super.cleanup();
    }
}

