/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.businessprocess.utils.migration;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.TimeZone;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.FilenameUtils;
import org.apache.xerces.dom.DeferredElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.carbon.humantask.TTask;
import org.wso2.carbon.humantask.core.deployment.HumanTaskDeploymentUnit;
import org.wso2.carbon.humantask.core.utils.HumanTaskStoreUtils;
import org.wso2.ei.businessprocess.utils.migration.db.DBQuery;
import org.wso2.ei.businessprocess.utils.migration.deployment.ArchiveBasedHumanTaskDeploymentUnitBuilder;
import org.wso2.ei.businessprocess.utils.migration.utils.MigrationToolUtil;
import org.xml.sax.SAXException;

public class MigrationExecutor {
    private static final int SUPER_TENANT = -1234;
    private static DBQuery query;
    private static String BPS_HOME;
    static String databaseURL;

    public static void main(String[] args) {
        try {
            if (System.getProperty("carbon.components.dir.path") != null) {
                MigrationExecutor.addJarFileUrls(new File(System.getProperty("carbon.components.dir.path")));
            }
            System.out.println("Initialize Migration...");
            System.out.println("==========================================");
            if (System.getProperty("carbon.home") != null) {
                System.out.println("Using carbon home directory : " + System.getProperty("carbon.home"));
            } else {
                System.out.println("Carbon Home not set, please check the migration tool script !!!!");
            }
            BPS_HOME = System.getProperty("carbon.home");
            MigrationExecutor.initializeDBConnection();
            TimeZone.setDefault(TimeZone.getTimeZone(System.getProperty("user.timezone")));
            String superTenantRepoPath = BPS_HOME + File.separator + "repository" + File.separator + "deployment" + File.separator + "server" + File.separator + "humantasks";
            String tenantsRepoPath = BPS_HOME + File.separator + "repository" + File.separator + "tenants";
            System.out.println("SUPER TENANT REPOSITORY PATH:" + superTenantRepoPath);
            System.out.println("TENANTS REPOSITORY PATH:" + tenantsRepoPath);
            query = new DBQuery(databaseURL);
            if (!MigrationExecutor.versionDBSchemasExists()) {
                System.out.println("DB Tables are not updated for BPS 3.2.0. Please run the sql script from dbscripts/migration directory and Try Again!!!!");
                return;
            }
            MigrationExecutor.migrateSuperTenantHTPacks(superTenantRepoPath);
            MigrationExecutor.migrateTenantsHTPacks(tenantsRepoPath);
            System.out.println("Migration Success!!!!");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("ERROR:Migration failed.Try Again!!!!");
        }
    }

    private static Connection initializeDBConnection() throws ParserConfigurationException, IOException, SAXException, ClassNotFoundException, SQLException {
        String databaseUsername = null;
        String databasePassword = null;
        String databaseDriver = null;
        boolean dbConfigFound = false;
        String configPath = System.getProperty("carbon.home") + File.separator + "conf" + File.separator + "datasources" + File.separator + "bps-datasources.xml";
        System.out.println("Using datasource config file at :" + configPath);
        File elementXmlFile = new File(configPath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setIgnoringComments(true);
        dbFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.parse(elementXmlFile);
        document.getDocumentElement().normalize();
        NodeList datasourceList = document.getDocumentElement().getElementsByTagName("datasource");
        for (int i = 0; i < datasourceList.getLength(); ++i) {
            Node datasource = datasourceList.item(i);
            String dbName = ((DeferredElementImpl)datasource).getElementsByTagName("name").item(0).getTextContent();
            if (!dbName.equals("BPS_DS")) continue;
            databaseURL = document.getDocumentElement().getElementsByTagName("url").item(i).getTextContent().split(";")[0];
            databaseDriver = document.getDocumentElement().getElementsByTagName("driverClassName").item(i).getTextContent();
            databaseUsername = document.getDocumentElement().getElementsByTagName("username").item(i).getTextContent();
            databasePassword = document.getDocumentElement().getElementsByTagName("password").item(i).getTextContent();
            dbConfigFound = true;
            break;
        }
        if (!dbConfigFound) {
            System.out.println("DB configurations not found or invalid!");
            System.exit(0);
        }
        Class.forName(databaseDriver);
        return DriverManager.getConnection(databaseURL, databaseUsername, databasePassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean versionDBSchemasExists() throws Exception {
        try {
            Connection conn = MigrationExecutor.initializeDBConnection();
            conn.setAutoCommit(false);
            ResultSet resultList = null;
            Statement stmt = null;
            try {
                stmt = conn.createStatement();
                String sql = query.getVERSION();
                resultList = stmt.executeQuery(sql);
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                if (resultList != null) {
                    resultList.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    private static boolean canRunScripts() throws Exception {
        try (BufferedReader br = null;){
            br = new BufferedReader(new InputStreamReader(System.in));
            System.out.println();
            System.out.println("ERROR:DB schemas were not found. Do you want to run scripts using tool?(Y/N)");
            String input = br.readLine().trim().toLowerCase();
            if (input.equals("y") || input.equals("yes")) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private static boolean migrateDB() throws Exception {
        System.out.println("Alteration to current DB schemas...");
        System.out.println("==========================================");
        conn.setAutoCommit(false);
        try (Connection conn = MigrationExecutor.initializeDBConnection();){
            conn.createStatement().execute(query.getHT_DEPLOYMENT_UNIT());
            System.out.println("Deployment Unit Table Created.");
            conn.createStatement().execute(query.getHT_VERSIONS());
            System.out.println("Version Table Created.");
            conn.createStatement().execute(query.getALTER_PACKAGE_NAME());
            conn.createStatement().execute(query.getALTER_TASK_DEF_NAME());
            conn.createStatement().execute(query.getALTER_TASK_VERSION());
            System.out.println("Table Columns Altered.");
            conn.commit();
            System.out.println("Database Alteration Success!!");
            boolean bl = true;
            return bl;
        }
    }

    private static void migrateSuperTenantHTPacks(String repoPath) throws Exception {
        System.out.println("Migration for Super Tenant...");
        System.out.println("==========================================");
        File repoDirectory = new File(repoPath);
        File[] deployedHumanTaskPacks = repoDirectory.listFiles();
        if (deployedHumanTaskPacks != null) {
            System.out.println("HumanTask Package\t|\tVersion");
            for (int i = 0; i < deployedHumanTaskPacks.length; ++i) {
                if (!deployedHumanTaskPacks[i].isFile() || !FilenameUtils.getExtension((String)deployedHumanTaskPacks[i].getName()).trim().equals("zip")) continue;
                MigrationExecutor.migrateHumanTasks(deployedHumanTaskPacks[i], -1234);
            }
        } else {
            System.out.println("No HumanTask Packages were found.");
        }
    }

    private static void migrateTenantsHTPacks(String repoPath) throws Exception {
        System.out.println("Migration for  Tenants...");
        System.out.println("==========================================");
        File tenantsDirectory = new File(repoPath);
        File[] listTenantDirs = tenantsDirectory.listFiles();
        if (listTenantDirs != null) {
            for (int i = 0; i < listTenantDirs.length; ++i) {
                if (!listTenantDirs[i].isDirectory() || !MigrationToolUtil.isInteger(listTenantDirs[i].getName())) continue;
                System.out.println("TenantID: " + listTenantDirs[i].getName());
                File[] deployedHumanTaskPacks = new File(listTenantDirs[i].getAbsolutePath() + File.separator + "humantasks").listFiles();
                if (deployedHumanTaskPacks != null) {
                    System.out.println("HumanTask Package\t|\tVersion");
                    for (int j = 0; j < deployedHumanTaskPacks.length; ++j) {
                        if (!deployedHumanTaskPacks[j].isFile() || !FilenameUtils.getExtension((String)deployedHumanTaskPacks[j].getName()).trim().equals("zip")) continue;
                        MigrationExecutor.migrateHumanTasks(deployedHumanTaskPacks[j], Integer.parseInt(listTenantDirs[i].getName()));
                    }
                    continue;
                }
                System.out.println("No HumanTask Packages were found.");
            }
        } else {
            System.out.println("No Tenant Repositories were found.");
        }
    }

    private static void migrateHumanTasks(File archiveFile, int tenantId) throws Exception {
        Connection conn = MigrationExecutor.initializeDBConnection();
        conn.setAutoCommit(false);
        String md5sum = HumanTaskStoreUtils.getMD5Checksum((File)archiveFile);
        String packageName = FilenameUtils.removeExtension((String)archiveFile.getName());
        Long version = MigrationExecutor.getNextVersion();
        String deployPath = "repository" + File.separator + "humantasks" + File.separator + tenantId + File.separator + packageName + "-" + version;
        HumanTaskDeploymentUnit humanTaskDU = MigrationExecutor.createHumanTaskDeploymentUnit(archiveFile, tenantId, md5sum, version);
        try {
            long deploymentID = MigrationExecutor.getNextDeploymentID();
            Date date = new Date();
            conn.createStatement().execute(query.getINSERT_DEPLOYMENT_UNIT(deploymentID, md5sum, date, deployPath, packageName + "-" + version, packageName, tenantId, version));
            TTask[] tasks = humanTaskDU.getTasks();
            if (tasks != null) {
                for (TTask task : tasks) {
                    QName taskQName = new QName(humanTaskDU.getNamespace(), task.getName());
                    conn.createStatement().execute(query.getUPDATE_TASKS(taskQName.toString(), tenantId, packageName, version));
                }
            }
            MigrationExecutor.setVersion();
            conn.commit();
            System.out.println(FilenameUtils.removeExtension((String)archiveFile.getName()) + "\t|\t" + version);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            conn.rollback();
            throw new Exception(ex);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    private static HumanTaskDeploymentUnit createHumanTaskDeploymentUnit(File archiveFile, int tenantId, String md5sum, long version) throws Exception {
        return new ArchiveBasedHumanTaskDeploymentUnitBuilder(BPS_HOME, archiveFile, tenantId, version, md5sum).createNewHumanTaskDeploymentUnit();
    }

    private static long getNextVersion() throws Exception {
        Connection conn = MigrationExecutor.initializeDBConnection();
        conn.setAutoCommit(false);
        ResultSet resultList = null;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            String sql = query.getVERSION();
            resultList = stmt.executeQuery(sql);
            String s_version = null;
            while (resultList.next()) {
                s_version = resultList.getString("TASK_VERSION");
            }
            if (s_version == null) {
                conn.createStatement().execute(query.getINSERT_VERSION());
                conn.commit();
                long l = 1L;
                return l;
            }
            Long version = Long.parseLong(s_version) + 1L;
            long l = version;
            return l;
        }
        catch (Exception ex) {
            throw new Exception(ex);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (resultList != null) {
                resultList.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    private static long getNextDeploymentID() throws Exception {
        Connection conn = MigrationExecutor.initializeDBConnection();
        conn.setAutoCommit(false);
        ResultSet resultList = null;
        Statement stmt = null;
        try {
            stmt = conn.createStatement();
            String sql = query.getDEPLOYMENT_UNIT_ID();
            resultList = stmt.executeQuery(sql);
            String s_version = null;
            while (resultList.next()) {
                s_version = resultList.getString("id");
            }
            if (s_version == null) {
                long l = 0L;
                return l;
            }
            Long id = Long.parseLong(s_version) + 1L;
            long l = id;
            return l;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new Exception(ex);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
            if (resultList != null) {
                resultList.close();
            }
            if (conn != null) {
                conn.close();
            }
        }
    }

    private static void setVersion() throws Exception {
        conn.setAutoCommit(false);
        try (Connection conn = MigrationExecutor.initializeDBConnection();){
            conn.createStatement().execute(query.getUPDATE_VERSION());
            conn.commit();
        }
    }

    private static void addJarFileUrls(File root) throws Exception {
        File[] children = root.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (!child.isFile() || !child.canRead() || !child.getName().toLowerCase().endsWith(".jar") || child.getName().toLowerCase().startsWith("org.apache.synapse.module") || child.getName().toLowerCase().startsWith("wss4j")) continue;
            MigrationExecutor.addPath(child.getPath());
        }
    }

    private static void addPath(String s) throws Exception {
        File f = new File(s);
        URL u = f.toURL();
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, u);
    }

    static {
        databaseURL = null;
    }
}

