/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.businessprocess.utils.migration.db;

import java.text.SimpleDateFormat;
import java.util.Date;

public class DBQuery {
    String databaseURL;
    private String INSERT_VERSION;
    private String INSERT_DEPLOYMENT_UNIT;
    private String UPDATE_TASKS;
    private String UPDATE_VERSION;
    private String DEPLOYMENT_UNIT_ID;
    private String VERSION;
    private String HT_DEPLOYMENT_UNIT;
    private String HT_VERSIONS;
    private String ALTER_PACKAGE_NAME;
    private String ALTER_TASK_DEF_NAME;
    private String ALTER_TASK_VERSION;

    public DBQuery(String databaseURL) {
        this.databaseURL = databaseURL;
        this.INSERT_VERSION = "INSERT INTO HT_VERSIONS(id,TASK_VERSION) VALUES(1,0)";
        this.UPDATE_VERSION = " UPDATE HT_VERSIONS SET TASK_VERSION=TASK_VERSION+1";
        this.VERSION = "SELECT TASK_VERSION from HT_VERSIONS";
        this.DEPLOYMENT_UNIT_ID = "SELECT id FROM HT_DEPLOYMENT_UNIT";
        this.ALTER_PACKAGE_NAME = "ALTER TABLE HT_TASK ADD COLUMN PACKAGE_NAME VARCHAR(255) ";
        this.ALTER_TASK_DEF_NAME = "ALTER TABLE HT_TASK ADD COLUMN TASK_DEF_NAME VARCHAR(255) ";
        this.ALTER_TASK_VERSION = "ALTER TABLE HT_TASK ADD COLUMN TASK_VERSION BIGINT";
        if (databaseURL.contains("mysql") || databaseURL.contains("sqlserver")) {
            this.HT_DEPLOYMENT_UNIT = "CREATE TABLE HT_DEPLOYMENT_UNIT(id BIGINT NOT NULL, CHECKSUM VARCHAR(255)NOT NULL, DEPLOYED_ON DATETIME, DEPLOY_DIR VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, PACKAGE_NAME VARCHAR(255) NOT NULL, STATUS VARCHAR(255) NOT NULL, TENANT_ID BIGINT NOT NULL, VERSION BIGINT NOT NULL, PRIMARY KEY (id))";
            this.HT_VERSIONS = "CREATE TABLE HT_VERSIONS (id BIGINT NOT NULL, TASK_VERSION BIGINT NOT NULL, PRIMARY KEY (id))";
        } else if (databaseURL.contains("oracle")) {
            this.HT_DEPLOYMENT_UNIT = "CREATE TABLE HT_DEPLOYMENT_UNIT (id NUMBER NOT NULL, CHECKSUM VARCHAR2(255) NOT NULL, DEPLOYED_ON TIMESTAMP, DEPLOY_DIR VARCHAR2(255) NOT NULL, NAME VARCHAR2(255) NOT NULL, PACKAGE_NAME VARCHAR2(255) NOT NULL, STATUS VARCHAR2(255) NOT NULL, TENANT_ID NUMBER NOT NULL, VERSION NUMBER NOT NULL, PRIMARY KEY (id))";
            this.HT_VERSIONS = "CREATE TABLE HT_VERSIONS (id NUMBER NOT NULL, TASK_VERSION NUMBER NOT NULL, PRIMARY KEY (id)) ";
            this.ALTER_TASK_VERSION = "ALTER TABLE HT_TASK ADD TASK_VERSION NUMBER";
            this.ALTER_PACKAGE_NAME = "ALTER TABLE HT_TASK ADD PACKAGE_NAME VARCHAR(255) ";
            this.ALTER_TASK_DEF_NAME = "ALTER TABLE HT_TASK ADD TASK_DEF_NAME VARCHAR(255)";
        } else if (databaseURL.contains("h2")) {
            this.HT_DEPLOYMENT_UNIT = "CREATE TABLE HT_DEPLOYMENT_UNIT (id BIGINT NOT NULL, CHECKSUM VARCHAR(255) NOT NULL, DEPLOYED_ON TIMESTAMP, DEPLOY_DIR VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, PACKAGE_NAME VARCHAR(255) NOT NULL, STATUS VARCHAR(255) NOT NULL, TENANT_ID BIGINT NOT NULL, VERSION BIGINT NOT NULL, PRIMARY KEY (id))";
            this.HT_VERSIONS = "CREATE TABLE HT_VERSIONS (id BIGINT NOT NULL, TASK_VERSION BIGINT NOT NULL, PRIMARY KEY (id))";
        } else if (databaseURL.contains("postgresql")) {
            this.HT_DEPLOYMENT_UNIT = "CREATE TABLE HT_DEPLOYMENT_UNIT (id BIGINT NOT NULL, CHECKSUM VARCHAR(255) NOT NULL, DEPLOYED_ON TIMESTAMP, DEPLOY_DIR VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, PACKAGE_NAME VARCHAR(255) NOT NULL, STATUS VARCHAR(255) NOT NULL, TENANT_ID BIGINT NOT NULL, VERSION BIGINT NOT NULL, PRIMARY KEY (id))";
            this.HT_VERSIONS = "CREATE TABLE HT_VERSIONS (id BIGINT NOT NULL, TASK_VERSION BIGINT NOT NULL, PRIMARY KEY (id))";
        } else if (databaseURL.contains("derby")) {
            this.HT_DEPLOYMENT_UNIT = "CREATE TABLE HT_DEPLOYMENT_UNIT(id BIGINT NOT NULL, CHECKSUM VARCHAR(255) NOT NULL, DEPLOYED_ON TIMESTAMP, DEPLOY_DIR VARCHAR(255) NOT NULL, NAME VARCHAR(255) NOT NULL, PACKAGE_NAME VARCHAR(255) NOT NULL, STATUS VARCHAR(255) NOT NULL, TENANT_ID BIGINT NOT NULL, VERSION BIGINT NOT NULL, PRIMARY KEY (id))";
            this.HT_VERSIONS = "CREATE TABLE HT_VERSIONS(id BIGINT NOT NULL,TASK_VERSION BIGINT NOT NULL, PRIMARY KEY (id))";
        } else {
            System.out.println("Unsupported DB Type \nor Invalid Driver Name!");
        }
    }

    public String getVERSION() {
        return this.VERSION;
    }

    public String getUPDATE_VERSION() {
        return this.UPDATE_VERSION;
    }

    public String getINSERT_VERSION() {
        return this.INSERT_VERSION;
    }

    public String getUPDATE_TASKS(String QName2, int tenantID, String packageName, long version) {
        this.setUPDATE_TASKS("UPDATE HT_TASK SET TASK_NAME ='" + QName2 + "-" + version + "',TASK_VERSION= " + version + ",PACKAGE_NAME='" + packageName + "' , TASK_DEF_NAME='" + QName2 + "' WHERE TASK_NAME='" + QName2 + "' AND TENANT_ID=" + tenantID);
        return this.UPDATE_TASKS;
    }

    public String getDEPLOYMENT_UNIT_ID() {
        return this.DEPLOYMENT_UNIT_ID;
    }

    public String getINSERT_DEPLOYMENT_UNIT(long id, String checkSum, Date deployOn, String deployPath, String name, String packageName, int tenantID, long version) {
        if (this.databaseURL.contains("oracle")) {
            this.setINSERT_DEPLOYMENT_UNIT("INSERT INTO HT_DEPLOYMENT_UNIT VALUES(" + id + ",'" + checkSum + "',sysdate,'" + deployPath + "','" + name + "','" + packageName + "','ACTIVE'," + tenantID + "," + version + ")");
        } else {
            this.setINSERT_DEPLOYMENT_UNIT("INSERT INTO HT_DEPLOYMENT_UNIT VALUES(" + id + ",'" + checkSum + "','" + new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(deployOn) + "','" + deployPath + "','" + name + "','" + packageName + "','ACTIVE'," + tenantID + "," + version + ")");
        }
        return this.INSERT_DEPLOYMENT_UNIT;
    }

    public void setINSERT_DEPLOYMENT_UNIT(String INSERT_DEPLOYMENT_UNIT) {
        this.INSERT_DEPLOYMENT_UNIT = INSERT_DEPLOYMENT_UNIT;
    }

    public String getUPDATE_TASKS() {
        return this.UPDATE_TASKS;
    }

    public void setUPDATE_TASKS(String UPDATE_TASKS) {
        this.UPDATE_TASKS = UPDATE_TASKS;
    }

    public String getALTER_TASK_VERSION() {
        return this.ALTER_TASK_VERSION;
    }

    public String getALTER_TASK_DEF_NAME() {
        return this.ALTER_TASK_DEF_NAME;
    }

    public String getALTER_PACKAGE_NAME() {
        return this.ALTER_PACKAGE_NAME;
    }

    public String getHT_DEPLOYMENT_UNIT() {
        return this.HT_DEPLOYMENT_UNIT;
    }

    public String getHT_VERSIONS() {
        return this.HT_VERSIONS;
    }
}

