/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.ei.businessprocess.utils.processcleanup;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xerces.dom.DeferredElementImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wso2.ei.businessprocess.utils.processcleanup.DBQuery;
import org.wso2.ei.businessprocess.utils.processcleanup.InstanceStatus;
import org.wso2.ei.businessprocess.utils.processcleanup.RegistryCleaner;
import org.xml.sax.SAXException;

public class CleanupExecutor {
    private static final Log log = LogFactory.getLog(CleanupExecutor.class);
    private static HashMap<String, List<String>> map;
    static String databaseURL;
    static String bpsHome;
    private static DBQuery query;

    private static String getProperty(String property) throws Exception {
        Properties prop = new Properties();
        String configPath = bpsHome + File.separator + "conf" + File.separator + "process-cleanup.properties";
        prop.load(new FileInputStream(configPath));
        return prop.getProperty(property);
    }

    private static Connection initializeDBConnection() throws ParserConfigurationException, IOException, SAXException, ClassNotFoundException, SQLException {
        String databaseUsername = null;
        String databasePassword = null;
        String databaseDriver = null;
        boolean dbConfigFound = false;
        bpsHome = System.getProperty("carbon.home");
        if (!bpsHome.endsWith(File.separator)) {
            bpsHome = bpsHome + File.separator;
        }
        System.out.println("Processcleanuptool startup - BPS HOME DIRECTORY : " + bpsHome);
        String configPath = bpsHome + File.separator + "conf" + File.separator + "datasources" + File.separator + "bps-datasources.xml";
        File elementXmlFile = new File(configPath);
        DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
        dbFactory.setIgnoringComments(true);
        dbFactory.setIgnoringElementContentWhitespace(true);
        DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
        Document document = dBuilder.parse(elementXmlFile);
        document.getDocumentElement().normalize();
        NodeList datasourceList = document.getDocumentElement().getElementsByTagName("datasource");
        for (int i = 0; i < datasourceList.getLength(); ++i) {
            Node datasource = datasourceList.item(i);
            String dbName = ((DeferredElementImpl)datasource).getElementsByTagName("name").item(0).getTextContent();
            if (!dbName.equals("BPS_DS")) continue;
            databaseURL = document.getDocumentElement().getElementsByTagName("url").item(i).getTextContent().split(";")[0];
            databaseDriver = document.getDocumentElement().getElementsByTagName("driverClassName").item(i).getTextContent();
            databaseUsername = document.getDocumentElement().getElementsByTagName("username").item(i).getTextContent();
            databasePassword = document.getDocumentElement().getElementsByTagName("password").item(i).getTextContent();
            dbConfigFound = true;
            break;
        }
        if (!dbConfigFound) {
            log.error((Object)"DB configurations not found or invalid!");
            System.exit(0);
        }
        Class.forName(databaseDriver);
        return DriverManager.getConnection(databaseURL, databaseUsername, databasePassword);
    }

    private static String getFilters() throws Exception {
        String filters;
        String[] filterStates = CleanupExecutor.getProperty("process.filterStates").split(",");
        InstanceStatus status = new InstanceStatus();
        for (String s : filterStates) {
            status.state.remove(s.trim());
        }
        switch (status.state.size()) {
            case 0: {
                filters = "";
                break;
            }
            case 1: {
                filters = " and s.DU not in \n(select s.DU \nfrom ODE_PROCESS_INSTANCE a, ODE_PROCESS b, STORE_PROCESS s \nwhere a.PROCESS_ID = b.ID \nand s.PID = b.PROCESS_ID \nand (";
                filters = filters + " a.INSTANCE_STATE = " + status.state.values().toArray()[0] + "))";
                break;
            }
            default: {
                filters = " and s.DU not in \n(select s.DU \nfrom ODE_PROCESS_INSTANCE a, ODE_PROCESS b, STORE_PROCESS s \nwhere a.PROCESS_ID = b.ID \nand s.PID = b.PROCESS_ID \nand (a.INSTANCE_STATE = " + status.state.values().toArray()[0];
                for (int i = 1; i < status.state.size(); ++i) {
                    filters = filters + " or a.INSTANCE_STATE = " + status.state.values().toArray()[i];
                }
                filters = filters + "))";
            }
        }
        return filters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean deletePackages(String packageName) throws Exception {
        Connection conn = CleanupExecutor.initializeDBConnection();
        conn.setAutoCommit(false);
        String clientTrustStorePath = CleanupExecutor.getProperty("clientTrustStorePath");
        String trustStorePassword = CleanupExecutor.getProperty("clientTrustStorePassword");
        String trustStoreType = CleanupExecutor.getProperty("clientTrustStoreType");
        System.out.println("Deleting package:" + packageName);
        String regPath = "/_system/config/bpel/packages/";
        boolean regCleanSuccess = RegistryCleaner.deleteRegistry(regPath, packageName, clientTrustStorePath, trustStorePassword, trustStoreType);
        if (regCleanSuccess) {
            List<String> processList = map.get(packageName);
            try {
                if (CleanupExecutor.getProperty("delete.instances").toLowerCase().equals("true")) {
                    CleanupExecutor.cleanProcessInstances(processList, conn);
                }
                for (String id : processList) {
                    conn.createStatement().execute(query.deleteFromOdeProcess(id));
                }
                conn.createStatement().execute(query.deleteFromStoreDu(packageName));
                conn.createStatement().execute(query.deleteFromStoreProcess(packageName));
                conn.commit();
                System.out.println("Database Cleaning Success!!");
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                String errMsg = "Database cleaning exception.";
                log.error((Object)errMsg, (Throwable)e);
                conn.rollback();
            }
            finally {
                if (conn != null) {
                    conn.close();
                }
            }
        }
        System.out.println("Cleanup Unsuccessful! (Server Error)");
        return false;
    }

    private static void cleanProcessInstances(List<String> processIdList, Connection conn) throws Exception {
        int i = 0;
        System.out.print("Instance Clean Count : 000000000");
        try {
            Statement stmt = conn.createStatement();
            for (String process : processIdList) {
                String sql = query.getInstancesSearchQuery(process);
                ResultSet rs = stmt.executeQuery(sql);
                while (rs.next()) {
                    String id = rs.getString("ID");
                    conn.createStatement().execute(query.deleteFromOdePartnerLink(id));
                    conn.createStatement().execute(query.deleteFromOdeScope(id));
                    conn.createStatement().execute(query.deleteFromOdeEvent(id));
                    conn.createStatement().execute(query.deleteFromOdeCorsetProp(id));
                    conn.createStatement().execute(query.deleteFromOdeCorrelationSet(id));
                    conn.createStatement().execute(query.deleteFromOdeXmlDataProp(id));
                    conn.createStatement().execute(query.deleteFromOdeXmlData(id));
                    conn.createStatement().execute(query.deleteFromOdeMexProp(id));
                    conn.createStatement().execute(query.deleteFromOdeMessage(id));
                    conn.createStatement().execute(query.deleteFromOdeMessageExchange(id));
                    conn.createStatement().execute(query.deleteFromOdeMessageRoute(id));
                    conn.createStatement().execute(query.deleteFromOdeProcessInstance(id));
                    System.out.print("\b\b\b\b\b\b\b\b\b");
                    System.out.print(String.format("%09d", ++i));
                }
                conn.commit();
            }
            System.out.println();
        }
        catch (SQLException e) {
            String errMsg = "Process instance clean exception.";
            log.error((Object)errMsg, (Throwable)e);
            throw new SQLException(e);
        }
    }

    private static HashMap<String, List<String>> getDeletablePackageList(String name) throws Exception {
        Statement stmt = CleanupExecutor.initializeDBConnection().createStatement();
        String filters = CleanupExecutor.getFilters();
        String sql = name != null ? query.getSearchByNameQuery(filters, name) : query.getSearchQuery(filters);
        ResultSet rs = stmt.executeQuery(sql);
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        while (rs.next()) {
            if (map.get(rs.getString("DU")) == null) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(rs.getString("ID"));
                map.put(rs.getString("DU"), list);
                continue;
            }
            ((List)map.get(rs.getString("DU"))).add(rs.getString("ID"));
        }
        String[] keys = map.keySet().toArray(new String[0]);
        for (int i = 0; i < map.size(); ++i) {
            String id = String.format("%9d", i + 1);
            System.out.println(String.format("%-10s | %s", id, keys[i]));
        }
        return map;
    }

    private static int[] getValidUserInput(int minOption, int maxOption, String message) throws Exception {
        boolean valid = false;
        int[] userInputs = new int[1];
        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        block2: do {
            System.out.println("\n" + message);
            String input = br.readLine();
            try {
                if (input.contains(",") && !input.contains(",,")) {
                    String[] optionsArray = input.split(",");
                    userInputs = new int[optionsArray.length];
                    for (int i = 0; i < optionsArray.length; ++i) {
                        userInputs[i] = Integer.parseInt(optionsArray[i]);
                        if (userInputs[i] <= minOption || userInputs[i] >= maxOption) {
                            System.out.println("Invalid Input!");
                            valid = false;
                            continue block2;
                        }
                        valid = true;
                    }
                    continue;
                }
                userInputs[0] = Integer.parseInt(input);
                if (userInputs[0] >= minOption && userInputs[0] <= maxOption) {
                    valid = true;
                    continue;
                }
                System.out.println("Invalid Input!");
            }
            catch (Exception e) {
                String errMsg = "Valid user input exception.";
                log.error((Object)errMsg, (Throwable)e);
            }
        } while (!valid);
        return userInputs;
    }

    public static void main(String[] args) throws Exception {
        if (System.getProperty("carbon.components.dir.path") != null) {
            CleanupExecutor.addJarFileUrls(new File(System.getProperty("carbon.components.dir.path")));
        }
        CleanupExecutor.initializeDBConnection();
        query = new DBQuery(databaseURL, bpsHome);
        TimeZone.setDefault(TimeZone.getTimeZone(CleanupExecutor.getProperty("user.timezone")));
        System.out.println("\n=============ATTENTION=================\nThis tool deletes selected process versions and optionally all corresponding process instances.\nHence take backups of DB before executing this tool.\nAlso read configuration information from the docs before running the tool.\n=======================================");
        System.out.println("\nInsert option number to list non-active BPEL packages");
        System.out.println("1. List All");
        System.out.println("2. Search and List by Process Name");
        System.out.println("3. Exit");
        int[] userInput = CleanupExecutor.getValidUserInput(1, 3, "Please Enter your option:");
        String name = null;
        switch (userInput[0]) {
            case 3: {
                System.exit(0);
                break;
            }
            case 2: {
                System.out.println("Please Enter Process Name:");
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                name = br.readLine().trim();
            }
            default: {
                System.out.println("Initialize JDBC Connection\n");
                try {
                    String id;
                    System.out.println("List of Non-Active BPEL Packages\n");
                    System.out.println(String.format(" %-9s | %s", "Option #", "Package Name"));
                    System.out.println("==========================================");
                    map = CleanupExecutor.getDeletablePackageList(name);
                    String[] list = map.keySet().toArray(new String[0]);
                    int deleteAllOption = list.length + 1;
                    switch (list.length) {
                        case 0: {
                            System.out.println("*** No Packages Found ***");
                            System.out.println("==========================================");
                            break;
                        }
                        case 1: {
                            System.out.println("==========================================");
                            break;
                        }
                        default: {
                            System.out.println("==========================================");
                            id = String.format("%9d", deleteAllOption);
                            System.out.println(String.format("%-10s | %s", id, "Delete All"));
                        }
                    }
                    id = String.format("%9d", 0);
                    System.out.println(String.format("%-10s | %s", id, "Exit"));
                    int[] options = CleanupExecutor.getValidUserInput(0, deleteAllOption, "Enter Option Numbers to Delete (comma separated):");
                    if (options[0] == 0) {
                        System.exit(0);
                        break;
                    }
                    if (options[0] == deleteAllOption) {
                        for (String packageName : list) {
                            CleanupExecutor.deletePackages(packageName);
                        }
                    } else {
                        for (int op : options) {
                            CleanupExecutor.deletePackages(list[op - 1]);
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    String errMsg = "Process deletion exception.";
                    log.error((Object)errMsg, (Throwable)e);
                }
            }
        }
    }

    private static void addJarFileUrls(File root) throws Exception {
        File[] children = root.listFiles();
        if (children == null) {
            return;
        }
        for (File child : children) {
            if (!child.isFile() || !child.canRead() || !child.getName().toLowerCase().endsWith(".jar") || child.getName().toLowerCase().startsWith("org.apache.synapse.module")) continue;
            CleanupExecutor.addPath(child.getPath());
        }
    }

    private static void addPath(String s) throws Exception {
        File f = new File(s);
        URL u = f.toURL();
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, u);
    }

    static {
        databaseURL = null;
        bpsHome = null;
    }
}

