/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.servers;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.esb.integration.common.utils.exception.RabbitMQTransportException;

public class RabbitMQServer {
    private static final Log log = LogFactory.getLog(RabbitMQServer.class);
    private boolean started;
    private File rabbitMQHome;

    public RabbitMQServer(String rabbitmqHome) throws RabbitMQTransportException {
        this.rabbitMQHome = new File(rabbitmqHome);
        if (!this.rabbitMQHome.exists() || !this.isValidRabbitMQHome()) {
            this.rabbitMQHome = null;
            log.error((Object)"Invalid RabbitMQ_HOME. RabbitMQ Broker will not connect as expected");
            throw new RabbitMQTransportException("Invalid RabbitMQ_HOME. RabbitMQ Broker will not connect as expected");
        }
        log.info((Object)("Using the RabbitMQ_HOME : " + this.rabbitMQHome.getAbsolutePath()));
    }

    private boolean isValidRabbitMQHome() {
        boolean rabbitmqctlFound = false;
        boolean rabbitmqserverFound = false;
        File[] files = this.rabbitMQHome.listFiles();
        if (files == null) {
            return false;
        }
        for (File f : files) {
            if (f.getName().contains("rabbitmqctl")) {
                rabbitmqctlFound = true;
                continue;
            }
            if (!f.getName().contains("rabbitmq-server")) continue;
            rabbitmqserverFound = true;
        }
        return rabbitmqctlFound && rabbitmqserverFound;
    }

    public void start() {
        log.info((Object)"Starting RabbitMQ Broker");
        this.execute("sh rabbitmq-server -detached");
        this.started = true;
    }

    public void stop() {
        log.info((Object)"Stopping RabbitMQ Broker");
        this.execute("sh rabbitmqctl stop");
        this.started = false;
    }

    public void initialize() {
        log.info((Object)"Initializing RabbitMQ Broker");
        this.execute("sh rabbitmqctl stop_app");
        this.execute("sh rabbitmqctl reset");
        this.execute("sh rabbitmqctl start_app");
    }

    public boolean isStarted() {
        return this.started;
    }

    private void execute(String command) {
        try {
            int n;
            Process process = Runtime.getRuntime().exec(command, null, this.rabbitMQHome);
            InputStream instream = process.getInputStream();
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            BufferedReader reader = new BufferedReader(new InputStreamReader(instream));
            while ((n = reader.read(buffer)) != -1) {
                ((Writer)writer).write(buffer, 0, n);
            }
            ((Reader)reader).close();
            instream.close();
            log.info((Object)((Object)writer).toString());
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
    }
}

