/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.common.utils.servers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.esb.integration.common.utils.servers.WireMonitorServer;

class WireMonitor
extends Thread {
    private Log log = LogFactory.getLog(WireMonitor.class);
    private static final int TIMEOUT_VALUE = 30000;
    private int port;
    private ServerSocket providerSocket;
    private Socket connection = null;
    private WireMonitorServer trigger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int ch;
            this.providerSocket = new ServerSocket(this.port, 10);
            this.log.info((Object)"Waiting for connection");
            this.connection = this.providerSocket.accept();
            this.log.info((Object)("Connection received from " + this.connection.getInetAddress().getHostName()));
            InputStream in = this.connection.getInputStream();
            StringBuffer buffer = new StringBuffer();
            StringBuffer headerBuffer = new StringBuffer();
            Long time = System.currentTimeMillis();
            int contentLength = -1;
            while ((ch = in.read()) != 1) {
                buffer.append((char)ch);
                if (contentLength == -1 && buffer.toString().endsWith("\r\n\r\n")) {
                    headerBuffer = new StringBuffer(buffer.toString());
                    if (buffer.toString().contains("Content-Length")) {
                        String headers = buffer.toString();
                        String contentLengthHeader = headers.substring(headers.indexOf("Content-Length:"));
                        contentLengthHeader = contentLengthHeader.substring(0, contentLengthHeader.indexOf("\r\n"));
                        contentLength = Integer.parseInt(contentLengthHeader.split(":")[1].trim());
                        buffer.setLength(0);
                    }
                }
                if (buffer.toString().length() != contentLength && System.currentTimeMillis() <= time + 30000L && !buffer.toString().contains("</soapenv:Envelope>")) continue;
            }
            this.trigger.response = headerBuffer.toString() + buffer.toString();
            this.trigger.isFinished = true;
            OutputStream out = this.connection.getOutputStream();
            out.write("HTTP/1.1 202 Accepted\r\n\r\n".getBytes());
            out.flush();
            out.close();
            in.close();
        }
        catch (IOException ioException) {
        }
        finally {
            try {
                this.connection.close();
                this.providerSocket.close();
            }
            catch (Exception e) {}
        }
    }

    public WireMonitor(int listenPort, WireMonitorServer trigger) {
        this.port = listenPort;
        this.trigger = trigger;
    }
}

