/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;

public class GenericJMSClient {
    private QueueConnection connection;
    private QueueSession session;
    private QueueSender sender;

    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        String dest = GenericJMSClient.getProperty("jms_dest", "dynamicQueues/JMSTextProxy");
        String type = GenericJMSClient.getProperty("jms_type", "text");
        String param = GenericJMSClient.getProperty("jms_payload", GenericJMSClient.getRandom(100.0, 0.9, true) + " " + (int)GenericJMSClient.getRandom(10000.0, 1.0, true) + " IBM");
        String sMsgCount = GenericJMSClient.getProperty("jms_msgcount", null);
        GenericJMSClient app = new GenericJMSClient();
        int msgCount = sMsgCount == null ? 1 : Integer.parseInt(sMsgCount);
        app.connect(dest);
        if ("text".equalsIgnoreCase(type)) {
            for (int i = 0; i < msgCount; ++i) {
                app.sendTextMessage(param);
            }
        } else if ("binary".equalsIgnoreCase(type)) {
            for (int i = 0; i < msgCount; ++i) {
                app.sendBytesMessage(GenericJMSClient.getBytesFromFile(param));
            }
        } else if ("pox".equalsIgnoreCase(type)) {
            for (int i = 0; i < msgCount; ++i) {
                app.sendTextMessage("<m:placeOrder xmlns:m=\"http://services.samples\">\n    <m:order>\n        <m:price>" + GenericJMSClient.getRandom(100.0, 0.9, true) + "</m:price>\n" + "        <m:quantity>" + (int)GenericJMSClient.getRandom(10000.0, 1.0, true) + "</m:quantity>\n" + "        <m:symbol>" + param + "</m:symbol>\n" + "    </m:order>\n" + "</m:placeOrder>");
            }
        } else {
            System.out.println("Unknown JMS message type");
        }
        app.shutdown();
    }

    private void connect(String destName) throws Exception {
        Properties env = new Properties();
        if (System.getProperty("java.naming.provider.url") == null) {
            env.put("java.naming.provider.url", "tcp://localhost:61616");
        }
        if (System.getProperty("java.naming.factory.initial") == null) {
            env.put("java.naming.factory.initial", "org.apache.activemq.jndi.ActiveMQInitialContextFactory");
        }
        InitialContext ic = new InitialContext(env);
        QueueConnectionFactory confac = (QueueConnectionFactory)ic.lookup("ConnectionFactory");
        this.connection = confac.createQueueConnection();
        this.session = this.connection.createQueueSession(false, 1);
        this.sender = this.session.createSender((Queue)ic.lookup(destName));
    }

    private void shutdown() throws Exception {
        this.sender.close();
        this.session.close();
        this.connection.close();
    }

    private void sendBytesMessage(byte[] payload) throws Exception {
        BytesMessage bm = this.session.createBytesMessage();
        bm.writeBytes(payload);
        this.sender.send((Message)bm);
    }

    private void sendTextMessage(String payload) throws Exception {
        TextMessage tm = this.session.createTextMessage(payload);
        this.sender.send((Message)tm);
    }

    public static byte[] getBytesFromFile(String fileName) throws IOException {
        int offset;
        File file = new File(fileName);
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    private static double getRandom(double base, double varience, boolean onlypositive) {
        double rand = Math.random();
        return (base + (double)(rand > 0.5 ? 1 : -1) * varience * base * rand) * (double)(onlypositive ? 1 : (rand > 0.5 ? 1 : -1));
    }
}

