/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

public class JSONClient {
    private String url = JSONClient.getProperty("addurl", "http://localhost:8280/services/JSONProxy");
    private String symbol = JSONClient.getProperty("symbol", "WSO2");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPost(String query) throws IOException {
        String charset = "UTF-8";
        URLConnection connection = new URL(this.url).openConnection();
        connection.setDoOutput(true);
        connection.setRequestProperty("Accept-Charset", charset);
        connection.setRequestProperty("Content-Type", "application/json;charset=" + charset);
        OutputStream output = null;
        try {
            output = connection.getOutputStream();
            output.write(query.getBytes(charset));
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException logOrIgnore) {
                    logOrIgnore.printStackTrace();
                }
            }
        }
        InputStream response = connection.getInputStream();
        String out = "[Fault] No Response.";
        if (response != null) {
            int len;
            StringBuilder sb = new StringBuilder();
            byte[] bytes = new byte[1024];
            while ((len = response.read(bytes)) != -1) {
                sb.append(new String(bytes, 0, len));
            }
            out = sb.toString();
        }
        System.out.println("Request =  " + query);
        System.out.println("Response = " + out);
    }

    public String getSymbol() {
        return this.symbol;
    }

    private static String getProperty(String name, String def) {
        String result = System.getProperty(name);
        if (result == null || result.length() == 0) {
            result = def;
        }
        return result;
    }

    public static void main(String[] args) throws IOException {
        JSONClient jsonClient = new JSONClient();
        String query = "{\"getQuote\":{\"request\":{\"symbol\":\"" + jsonClient.getSymbol() + "\"}}}";
        jsonClient.doPost(query);
    }
}

