/*
 * Decompiled with CFR 0.152.
 */
package samples.userguide;

import samples.userguide.ServiceInvoker;

public class ThreadedClient {
    public static final int STATELESS = 0;
    public static final int SOAP_SESSION = 1;
    public static final int SIMPLE_CLIENT_SESSION = 2;
    public static final int TRANSPORT_SESSION = 3;
    private int session = 0;

    public static void main(String[] args) {
        new ThreadedClient().work();
    }

    public void work() {
        int i;
        String epr1 = System.getProperty("epr");
        if (epr1 == null) {
            epr1 = "http://localhost:8280";
        }
        System.out.println("EPR: " + epr1);
        String op = System.getProperty("op");
        if (op == null) {
            op = "sleepOperation";
        }
        System.out.println("Operation: " + op);
        long requests = 10L;
        String requestsProp = System.getProperty("req");
        if (requestsProp != null) {
            requests = Long.parseLong(requestsProp);
        }
        System.out.println("Number of requests: " + requests);
        String loadParameter = System.getProperty("load");
        if (loadParameter == null) {
            loadParameter = "1000";
        }
        System.out.println("Load: " + loadParameter);
        long msgSize = 0L;
        String msgSizeProp = System.getProperty("msg");
        if (msgSizeProp != null) {
            msgSize = Long.parseLong(msgSizeProp);
        }
        System.out.println("Number of dummy elements in the message: " + msgSize);
        String sessionProp = System.getProperty("session");
        if (sessionProp == null) {
            this.session = 0;
        } else if (sessionProp.equalsIgnoreCase("client")) {
            this.session = 2;
        } else if (sessionProp.equalsIgnoreCase("transport")) {
            this.session = 3;
        }
        int clients = 2;
        String clientsProp = System.getProperty("t");
        if (clientsProp != null) {
            clients = Integer.parseInt(clientsProp);
        }
        System.out.println("Number of client threads: " + clients);
        ServiceInvoker[] invokers = new ServiceInvoker[clients];
        for (int i2 = 0; i2 < clients; ++i2) {
            ServiceInvoker invoker = new ServiceInvoker(epr1, op);
            if (this.session != 0) {
                invoker.setStatefull(true);
            }
            invoker.setInvokerName("CLIENT " + i2);
            invoker.setIterations(requests);
            invoker.setLoad(loadParameter);
            invoker.addDummyElements(msgSize);
            if (this.session == 2) {
                invoker.setClientSessionID("CLIENT " + i2);
            }
            invokers[i2] = invoker;
        }
        long t1 = System.currentTimeMillis();
        for (i = 0; i < clients; ++i) {
            invokers[i].start();
        }
        try {
            for (i = 0; i < clients; ++i) {
                invokers[i].join();
            }
        }
        catch (InterruptedException e) {
            System.out.println("ERROR: A client thread is interrupted while sending requests.");
        }
        long t2 = System.currentTimeMillis();
        System.out.println("\n================================================================\n");
        for (int i3 = 0; i3 < clients; ++i3) {
            System.out.println(invokers[i3].getInvokerName() + " completed requests in " + invokers[i3].getRunningTime() + " milliseconds.");
        }
        System.out.println("Time taken for completing all the requests is " + (t2 - t1) + " milliseconds.");
    }
}

