/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.esb.integration.services.jaxrs.peoplesample;

import java.net.URI;
import java.util.Collection;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.wso2.esb.integration.services.jaxrs.peoplesample.PeopleService;
import org.wso2.esb.integration.services.jaxrs.peoplesample.bean.Person;

@Path(value="/people")
public class PeopleRestService {
    @Inject
    private PeopleService peopleService;

    public void PeopleRestService() {
        this.peopleService.setInitPeople();
    }

    @Produces(value={"application/json"})
    @GET
    public Collection<Person> getPeople(@QueryParam(value="page") @DefaultValue(value="1") int page) {
        return this.peopleService.getPeople(page, 5);
    }

    @Produces(value={"application/json"})
    @PUT
    public Person addPerson(@FormParam(value="email") String email) {
        return this.peopleService.addPerson(email);
    }

    @Produces(value={"application/json"})
    @Path(value="/{email}")
    @GET
    public Person getPeople(@PathParam(value="email") String email) {
        return this.peopleService.getByEmail(email);
    }

    @Produces(value={"application/json", "application/x-www-form-urlencoded"})
    @POST
    public Response addPersonQueryParam(@Context UriInfo uriInfo, @QueryParam(value="email") String email, @QueryParam(value="firstName") String firstName, @QueryParam(value="lastName") String lastName) {
        this.peopleService.addPerson(email, firstName, lastName);
        return Response.created((URI)uriInfo.getRequestUriBuilder().path(email).build(new Object[0])).build();
    }

    @Produces(value={"application/json"})
    @Path(value="/{email}")
    @HEAD
    public Response checkPerson(@PathParam(value="email") String email) {
        if (this.peopleService.checkPersonByEmail(email)) {
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @Produces(value={"application/json"})
    @Path(value="/{email}")
    @PUT
    public Person updatePersonQueryParam(@PathParam(value="email") String email, @QueryParam(value="firstName") String firstName, @QueryParam(value="lastName") String lastName) {
        Person person = this.peopleService.getByEmail(email);
        if (firstName != null) {
            person.setFirstName(firstName);
        }
        if (lastName != null) {
            person.setLastName(lastName);
        }
        return person;
    }

    @Path(value="/{email}")
    @DELETE
    public Response deletePerson(@PathParam(value="email") String email) {
        this.peopleService.removePerson(email);
        return Response.ok().build();
    }

    @Produces(value={"application/json"})
    @Path(value="/options")
    @OPTIONS
    public Response getOptions(@Context HttpHeaders headers, @Context Request request) {
        return Response.ok().header("Access-Control-Allow-Methods", (Object)"GET POST DELETE PUT OPTIONS").header("Access-Control-Allow-Credentials", (Object)"false").header("Access-Control-Request-Headers", (Object)"application/json").build();
    }
}

