/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.sample.identity.oauth2.grant.password;

import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.identity.oauth2.IdentityOAuth2Exception;
import org.wso2.carbon.identity.oauth2.dto.OAuth2AccessTokenRespDTO;
import org.wso2.carbon.identity.oauth2.token.OAuthTokenReqMessageContext;
import org.wso2.carbon.identity.oauth2.token.handlers.grant.PasswordGrantHandler;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class ModifiedAccessTokenPasswordGrant
extends PasswordGrantHandler {
    private static Log log = LogFactory.getLog(ModifiedAccessTokenPasswordGrant.class);

    public OAuth2AccessTokenRespDTO issue(OAuthTokenReqMessageContext tokReqMsgCtx) throws IdentityOAuth2Exception {
        OAuth2AccessTokenRespDTO tokenRespDTO = super.issue(tokReqMsgCtx);
        tokenRespDTO.setAccessToken(this.generateAccessToken(tokReqMsgCtx.getAuthorizedUser().toString()));
        return tokenRespDTO;
    }

    private String generateAccessToken(String userName) {
        String token = UUID.randomUUID().toString();
        userName = MultitenantUtils.getTenantAwareUsername((String)userName);
        String email = null;
        try {
            email = CarbonContext.getThreadLocalCarbonContext().getUserRealm().getUserStoreManager().getUserClaimValue(userName, "http://wso2.org/claims/emailaddress", null);
        }
        catch (UserStoreException e) {
            log.error((Object)e);
        }
        if (email != null) {
            token = token + ":" + email;
        }
        return token;
    }
}

