/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.scim.sample.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.axiom.om.util.Base64;

public class SCIMSamplesUtils {
    public static final String CONTENT_TYPE = "application/json";
    public static final String IS_HOME = ".." + File.separator + ".." + File.separator;
    public static final String TRUST_STORE_PATH = IS_HOME + "repository" + File.separator + "resources" + File.separator + "security" + File.separator + "wso2carbon.jks";
    public static final String TRUST_STORE_PASS = "wso2carbon";
    public static final String PROPERTIES_FILE_NAME = "client.properties";
    public static final String PROPERTY_NAME_USER_ENDPOINT_URL = "user.endpoint";
    public static final String PROPERTY_NAME_GROUP_ENDPOINT_URL = "group.endpoint";
    public static final String PROPERTY_NAME_USER_NAME = "provisioning.user.name";
    public static final String PROPERTY_NAME_PASSWORD = "provisioning.password";
    public static final String PROPERTY_NAME_ENABLE_OAUTH = "enable.oauth";
    public static final String PROPERTY_NAME_ACCESS_TOKEN = "oauth.access.token";
    public static final String USER_FILTER = "filter=userNameEq";
    public static final String GROUP_FILTER = "filter=displayNameEq";
    public static String userEndpointURL = null;
    public static String groupEndpointURL = null;
    public static String userName = null;
    public static String password = null;
    public static boolean enableOAuth = false;
    public static String oauthAccessToken = null;
    public static String userNameToCreateUser = "HasiniTG";
    public static String userNameToUpdateUser = "HasiniG";
    public static String userNameToDeleteUser = "HasiniG";
    public static String groupDisplayNameToCreateGroup = "eng";
    public static String updatedGroupDisplayName = "Engineering";
    public static String groupDisplayNameToDeleteGroup = "Engineering";

    public static void setKeyStore() {
        System.setProperty("javax.net.ssl.trustStore", TRUST_STORE_PATH);
        System.setProperty("javax.net.ssl.trustStorePassword", TRUST_STORE_PASS);
    }

    public static String getBase64EncodedBasicAuthHeader(String userName, String password) {
        String concatenatedCredential = userName + ":" + password;
        byte[] byteValue = concatenatedCredential.getBytes();
        String encodedAuthHeader = Base64.encode((byte[])byteValue);
        encodedAuthHeader = "Basic " + encodedAuthHeader;
        return encodedAuthHeader;
    }

    public static void loadConfiguration() throws IOException {
        Properties properties = new Properties();
        FileInputStream freader = new FileInputStream(PROPERTIES_FILE_NAME);
        properties.load(freader);
        userEndpointURL = properties.getProperty(PROPERTY_NAME_USER_ENDPOINT_URL);
        groupEndpointURL = properties.getProperty(PROPERTY_NAME_GROUP_ENDPOINT_URL);
        userName = properties.getProperty(PROPERTY_NAME_USER_NAME);
        password = properties.getProperty(PROPERTY_NAME_PASSWORD);
        String isOAuth = properties.getProperty(PROPERTY_NAME_ENABLE_OAUTH);
        enableOAuth = Boolean.parseBoolean(isOAuth);
        oauthAccessToken = properties.getProperty(PROPERTY_NAME_ACCESS_TOKEN);
    }

    public static String getAuthorizationHeader() {
        if (enableOAuth) {
            return "Bearer " + oauthAccessToken;
        }
        return SCIMSamplesUtils.getBase64EncodedBasicAuthHeader(userName, password);
    }
}

