/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.p2;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.sisu.equinox.launching.internal.P2ApplicationLauncher;
import org.wso2.maven.p2.BundleArtifact;
import org.wso2.maven.p2.EquinoxLauncher;
import org.wso2.maven.p2.FeatureArtifact;
import org.wso2.maven.p2.P2Profile;
import org.wso2.maven.p2.generate.utils.FileManagementUtil;
import org.wso2.maven.p2.generate.utils.MavenUtils;
import org.wso2.maven.p2.generate.utils.P2Utils;

public class RepositoryGenMojo
extends AbstractMojo {
    private String name;
    private URL metadataRepository;
    private URL artifactRepository;
    private ArrayList featureArtifacts;
    private ArrayList bundleArtifacts;
    private ArrayList categories;
    private boolean publishArtifacts;
    private boolean publishArtifactRepository;
    private EquinoxLauncher equinoxLauncher;
    private P2Profile p2Profile;
    private MavenProject project;
    private boolean archive;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver resolver;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private P2ApplicationLauncher launcher;
    private int forkedProcessTimeoutInSeconds;
    private ArrayList processedFeatureArtifacts;
    private ArrayList processedP2LauncherFiles;
    private File targetDir;
    private File tempDir;
    private File sourceDir;
    private File p2AgentDir;
    private ArrayList processedBundleArtifacts;
    private File REPO_GEN_LOCATION;
    private File categoryDeinitionFile;
    private File ARCHIVE_FILE;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.createRepo();
        this.performMopUp();
    }

    public void createRepo() throws MojoExecutionException, MojoFailureException {
        try {
            this.getProcessedFeatureArtifacts();
            this.getProcessedBundleArtifacts();
            this.createAndSetupPaths();
            this.extractFeatures();
            this.copyBundleArtifacts();
            this.copyResources();
            this.getLog().info((CharSequence)"Running Equinox P2 Publisher Application for Repository Generation");
            this.generateRepository();
            this.getLog().info((CharSequence)"Running Equinox P2 Category Publisher Application for the Generated Repository");
            this.updateRepositoryWithCategories();
            this.archiveRepo();
        }
        catch (Exception e) {
            this.getLog().error((CharSequence)e.getMessage(), (Throwable)e);
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private void copyResources() throws MojoExecutionException {
        List resources = this.project.getResources();
        if (resources != null) {
            this.getLog().info((CharSequence)"Copying resources");
            for (Object obj : resources) {
                if (!(obj instanceof Resource)) continue;
                Resource resource = (Resource)obj;
                try {
                    File resourceFolder = new File(resource.getDirectory());
                    if (!resourceFolder.exists()) continue;
                    this.getLog().info((CharSequence)("   " + resource.getDirectory()));
                    FileManagementUtil.copyDirectory(resourceFolder, this.REPO_GEN_LOCATION);
                }
                catch (IOException e) {
                    throw new MojoExecutionException("Unable copy resources: " + resource.getDirectory(), (Exception)e);
                }
            }
        }
    }

    private String getPublisherApplication() {
        return "org.eclipse.equinox.p2.publisher.FeaturesAndBundlesPublisher";
    }

    private void generateRepository() throws Exception {
        P2ApplicationLauncher launcher = this.launcher;
        launcher.setWorkingDirectory(this.project.getBasedir());
        launcher.setApplicationName(this.getPublisherApplication());
        this.addArguments(launcher);
        int result = launcher.execute(this.forkedProcessTimeoutInSeconds);
        if (result != 0) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
    }

    private void addArguments(P2ApplicationLauncher launcher) throws IOException, MalformedURLException {
        launcher.addArguments(new String[]{"-source", this.sourceDir.getAbsolutePath(), "-metadataRepository", this.metadataRepository.toString(), "-metadataRepositoryName", this.getRepositoryName(), "-artifactRepository", this.metadataRepository.toString(), "-artifactRepositoryName", this.getRepositoryName(), "-publishArtifacts", "-publishArtifactRepository", "-compress", "-append"});
    }

    private void extractFeatures() throws MojoExecutionException {
        ArrayList processedFeatureArtifacts = this.getProcessedFeatureArtifacts();
        if (processedFeatureArtifacts == null) {
            return;
        }
        for (FeatureArtifact featureArtifact : processedFeatureArtifacts) {
            try {
                this.getLog().info((CharSequence)("Extracting feature " + featureArtifact.getGroupId() + ":" + featureArtifact.getArtifactId()));
                FileManagementUtil.unzip(featureArtifact.getArtifact().getFile(), this.sourceDir);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error occured when extracting the Feature Artifact: " + featureArtifact.toString(), e);
            }
        }
    }

    private void copyBundleArtifacts() throws MojoExecutionException {
        ArrayList processedBundleArtifacts = this.getProcessedBundleArtifacts();
        if (processedBundleArtifacts == null) {
            return;
        }
        File pluginsDir = new File(this.sourceDir, "plugins");
        for (BundleArtifact bundleArtifact : processedBundleArtifacts) {
            try {
                File file = bundleArtifact.getArtifact().getFile();
                FileManagementUtil.copy(file, new File(pluginsDir, file.getName()));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error occured when extracting the Feature Artifact: " + bundleArtifact.toString(), e);
            }
        }
    }

    private ArrayList getProcessedFeatureArtifacts() throws MojoExecutionException {
        if (this.processedFeatureArtifacts != null) {
            return this.processedFeatureArtifacts;
        }
        if (this.featureArtifacts == null || this.featureArtifacts.size() == 0) {
            return null;
        }
        this.processedFeatureArtifacts = new ArrayList();
        Iterator iter = this.featureArtifacts.iterator();
        while (iter.hasNext()) {
            FeatureArtifact f = null;
            Object obj = iter.next();
            try {
                f = obj instanceof FeatureArtifact ? (FeatureArtifact)obj : (obj instanceof String ? FeatureArtifact.getFeatureArtifact(obj.toString()) : (FeatureArtifact)obj);
                f.resolveVersion(this.getProject());
                f.setArtifact(MavenUtils.getResolvedArtifact(f, this.getArtifactFactory(), this.remoteRepositories, this.getLocalRepository(), this.getResolver()));
                this.processedFeatureArtifacts.add(f);
            }
            catch (Exception e) {
                throw new MojoExecutionException("Error occured when processing the Feature Artifact: " + obj.toString(), e);
            }
        }
        return this.processedFeatureArtifacts;
    }

    private void archiveRepo() throws MojoExecutionException {
        if (this.isArchive()) {
            this.getLog().info((CharSequence)"Generating repository archive...");
            FileManagementUtil.zipFolder(this.REPO_GEN_LOCATION.toString(), this.ARCHIVE_FILE.toString());
            this.getLog().info((CharSequence)("Repository Archive: " + this.ARCHIVE_FILE.toString()));
            FileManagementUtil.deleteDirectories(this.REPO_GEN_LOCATION);
        }
    }

    private ArrayList getProcessedBundleArtifacts() throws MojoExecutionException {
        if (this.processedBundleArtifacts != null) {
            return this.processedBundleArtifacts;
        }
        if (this.bundleArtifacts == null || this.bundleArtifacts.size() == 0) {
            return null;
        }
        this.processedBundleArtifacts = new ArrayList();
        for (Object obj : this.bundleArtifacts) {
            BundleArtifact f = obj instanceof BundleArtifact ? (BundleArtifact)obj : (obj instanceof String ? BundleArtifact.getBundleArtifact(obj.toString()) : (BundleArtifact)obj);
            f.resolveVersion(this.getProject());
            f.setArtifact(MavenUtils.getResolvedArtifact(f, this.getArtifactFactory(), this.remoteRepositories, this.getLocalRepository(), this.getResolver()));
            this.processedBundleArtifacts.add(f);
        }
        return this.processedBundleArtifacts;
    }

    private void createAndSetupPaths() throws Exception {
        this.targetDir = new File(this.getProject().getBasedir(), "target");
        String timestampVal = String.valueOf(new Date().getTime());
        this.tempDir = new File(this.targetDir, "tmp." + timestampVal);
        this.sourceDir = new File(this.tempDir, "featureExtract");
        this.sourceDir.mkdirs();
        this.metadataRepository = this.artifactRepository == null ? this.metadataRepository : this.artifactRepository;
        URL uRL = this.artifactRepository = this.metadataRepository == null ? this.artifactRepository : this.metadataRepository;
        if (this.metadataRepository == null) {
            File repo = new File(this.targetDir, this.getProject().getArtifactId() + "_" + this.getProject().getVersion());
            this.artifactRepository = this.metadataRepository = repo.toURL();
        }
        this.REPO_GEN_LOCATION = new File(this.metadataRepository.getFile().replace("/", File.separator));
        this.ARCHIVE_FILE = new File(this.targetDir, this.getProject().getArtifactId() + "_" + this.getProject().getVersion() + ".zip");
        this.categoryDeinitionFile = File.createTempFile("equinox-p2", "category");
    }

    private void updateRepositoryWithCategories() throws Exception {
        if (!this.isCategoriesAvailable()) {
            return;
        }
        P2Utils.createCategoryFile(this.getProject(), this.categories, this.categoryDeinitionFile, this.getArtifactFactory(), this.getRemoteRepositories(), this.getLocalRepository(), this.getResolver());
        P2ApplicationLauncher launcher = this.launcher;
        launcher.setWorkingDirectory(this.project.getBasedir());
        launcher.setApplicationName("org.eclipse.equinox.p2.publisher.CategoryPublisher");
        launcher.addArguments(new String[]{"-metadataRepository", this.metadataRepository.toString(), "-categoryDefinition", this.categoryDeinitionFile.toURI().toString(), "-categoryQualifier", "-compress", "-append"});
        int result = launcher.execute(this.forkedProcessTimeoutInSeconds);
        if (result != 0) {
            throw new MojoFailureException("P2 publisher return code was " + result);
        }
    }

    private boolean isCategoriesAvailable() {
        return this.categories != null && this.categories.size() != 0;
    }

    private void performMopUp() {
    }

    public void setP2Profile(P2Profile p2Profile) {
        this.p2Profile = p2Profile;
    }

    public P2Profile getP2Profile() {
        return this.p2Profile;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public void setResolver(ArtifactResolver resolver) {
        this.resolver = resolver;
    }

    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public void setRemoteRepositories(List remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public ArtifactResolver getResolver() {
        return this.resolver;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public String getRepositoryName() {
        if (this.name == null) {
            return this.getProject().getArtifactId();
        }
        return this.name;
    }

    public boolean isArchive() {
        return this.archive;
    }
}

