/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.maven.plugin.datasource;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.FactoryConfigurationError;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.wso2.maven.core.model.AbstractXMLDoc;
import org.wso2.maven.plugin.datasource.DSSArtifact;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DSSProjectArtifacts
extends AbstractXMLDoc
implements Observer {
    List<DSSArtifact> dssArtifacts = new ArrayList<DSSArtifact>();
    private File source;
    private static final Logger LOGGER = Logger.getLogger(DSSProjectArtifacts.class.getName());

    @Override
    public void update(Observable o, Object arg) {
    }

    protected void deserialize(OMElement documentElement) throws Exception {
        List artifactElements = this.getChildElements(documentElement, "artifact");
        for (OMElement omElement : artifactElements) {
            DSSArtifact artifact = new DSSArtifact();
            artifact.setName(this.getAttribute(omElement, "name"));
            artifact.setVersion(this.getAttribute(omElement, "version"));
            artifact.setType(this.getAttribute(omElement, "type"));
            artifact.setServerRole(this.getAttribute(omElement, "serverRole"));
            artifact.setGroupId(this.getAttribute(omElement, "groupId"));
            artifact.setFile(this.getChildElements(omElement, "file").size() > 0 ? ((OMElement)this.getChildElements(omElement, "file").get(0)).getText() : null);
            this.dssArtifacts.add(artifact);
        }
    }

    protected String serialize() throws Exception {
        String result = null;
        OMDocument document = factory.createOMDocument();
        OMElement documentElement = this.getDocumentElement();
        document.addChild((OMNode)documentElement);
        try {
            result = this.getPretifiedString(documentElement);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unable to Serialize Artifact");
            return null;
        }
        return result;
    }

    protected String getDefaultName() {
        return null;
    }

    public void addDSSArtifact(DSSArtifact artifact) {
        this.dssArtifacts.add(artifact);
    }

    public boolean removeDSSArtifact(DSSArtifact artifact) {
        return this.dssArtifacts.remove(artifact);
    }

    public List<DSSArtifact> getAllDSSArtifacts() {
        return Collections.unmodifiableList(this.dssArtifacts);
    }

    public OMElement getDocumentElement() {
        OMElement documentElement = this.getElement("artifacts", "");
        for (DSSArtifact dssArtifact : this.dssArtifacts) {
            OMElement artifactElement = this.getElement("artifact", "");
            if (!dssArtifact.isAnonymous()) {
                this.addAttribute(artifactElement, "name", dssArtifact.getName());
            }
            if (!dssArtifact.isAnonymous() && dssArtifact.getGroupId() != null) {
                this.addAttribute(artifactElement, "groupId", dssArtifact.getGroupId());
            }
            if (!dssArtifact.isAnonymous() && dssArtifact.getVersion() != null) {
                this.addAttribute(artifactElement, "version", dssArtifact.getVersion());
            }
            if (dssArtifact.getType() != null) {
                this.addAttribute(artifactElement, "type", dssArtifact.getType());
            }
            if (dssArtifact.getServerRole() != null) {
                this.addAttribute(artifactElement, "serverRole", dssArtifact.getServerRole());
            }
            if (dssArtifact.getFile() != null) {
                artifactElement.addChild((OMNode)this.getElement("file", dssArtifact.getFile()));
            }
            documentElement.addChild((OMNode)artifactElement);
        }
        return documentElement;
    }

    public void setSource(File source) {
        this.source = source;
    }

    public File getSource() {
        return this.source;
    }

    public File toFile() throws Exception {
        File savedFile = new File(this.toFile(this.getSource()).toString());
        return savedFile;
    }

    public void fromFile(File file) throws FactoryConfigurationError, Exception {
        this.setSource(file);
        if (this.getSource().exists()) {
            this.deserialize(this.getSource());
        }
    }
}

