/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.common;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.contrib.ssl.EasySSLProtocolSocketFactory;
import org.apache.commons.httpclient.methods.DeleteMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.mdm.integration.common.MDMResponse;

public class MDMHttpClient {
    private String backEndUrl;
    private String authrizationString;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private static final String AUTHORIZATION = "Authorization";
    private static Log log = LogFactory.getLog(MDMHttpClient.class);

    public MDMHttpClient(String backEndUrl, String contentType, String authorization) {
        this.backEndUrl = backEndUrl;
        this.requestHeaders.put("Content-Type", contentType);
        if (authorization != null || !authorization.isEmpty()) {
            this.authrizationString = authorization;
            this.requestHeaders.put(AUTHORIZATION, authorization);
        }
    }

    public String getAuthrizationString() {
        return this.authrizationString;
    }

    public void setAuthrizationString(String authrizationString) {
        this.authrizationString = authrizationString;
    }

    public void setHttpHeader(String headerName, String value) {
        this.requestHeaders.put(headerName, value);
    }

    public String getHttpHeader(String headerName) {
        return this.requestHeaders.get(headerName);
    }

    public void removeHttpHeader(String headerName) {
        this.requestHeaders.remove(headerName);
    }

    public MDMResponse post(String endpoint, String body) {
        HttpClient client = new HttpClient();
        try {
            EasySSLProtocolSocketFactory socketFactory = new EasySSLProtocolSocketFactory();
            Protocol https = new Protocol("https", (ProtocolSocketFactory)socketFactory, 9443);
            Protocol.registerProtocol((String)"https", (Protocol)https);
            String url = this.backEndUrl + endpoint;
            PostMethod method = new PostMethod(url);
            method.setRequestHeader(AUTHORIZATION, this.authrizationString);
            StringRequestEntity requestEntity = new StringRequestEntity(body, this.requestHeaders.get("Content-Type"), "UTF-8");
            method.setRequestEntity((RequestEntity)requestEntity);
            MDMResponse mdmResponse = new MDMResponse();
            mdmResponse.setStatus(client.executeMethod((HttpMethod)method));
            mdmResponse.setBody(method.getResponseBodyAsString());
            return mdmResponse;
        }
        catch (GeneralSecurityException e) {
            log.error((Object)"GeneralSecurityException Error occurred while creating an EasySSLProtocolSocketFactory object", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Exception occurred while sending the POST request to " + endpoint), (Throwable)e);
        }
        return null;
    }

    public MDMResponse put(String endpoint, String body) {
        HttpClient client = new HttpClient();
        try {
            EasySSLProtocolSocketFactory socketFactory = new EasySSLProtocolSocketFactory();
            Protocol https = new Protocol("https", (ProtocolSocketFactory)socketFactory, 9443);
            Protocol.registerProtocol((String)"https", (Protocol)https);
            String url = this.backEndUrl + endpoint;
            PutMethod method = new PutMethod(url);
            method.setRequestHeader(AUTHORIZATION, this.authrizationString);
            StringRequestEntity requestEntity = new StringRequestEntity(body, this.requestHeaders.get("Content-Type"), "UTF-8");
            method.setRequestEntity((RequestEntity)requestEntity);
            MDMResponse mdmResponse = new MDMResponse();
            mdmResponse.setStatus(client.executeMethod((HttpMethod)method));
            mdmResponse.setBody(method.getResponseBodyAsString());
            return mdmResponse;
        }
        catch (GeneralSecurityException e) {
            log.error((Object)"GeneralSecurityException Error occurred while creating an EasySSLProtocolSocketFactory object", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Exception occurred while sending the PUT request to " + endpoint), (Throwable)e);
        }
        return null;
    }

    public MDMResponse get(String endpoint) {
        HttpClient client = new HttpClient();
        try {
            EasySSLProtocolSocketFactory socketFactory = new EasySSLProtocolSocketFactory();
            Protocol https = new Protocol("https", (ProtocolSocketFactory)socketFactory, 9443);
            Protocol.registerProtocol((String)"https", (Protocol)https);
            String url = this.backEndUrl + endpoint;
            GetMethod method = new GetMethod(url);
            method.setRequestHeader(AUTHORIZATION, this.authrizationString);
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            MDMResponse mdmResponse = new MDMResponse();
            mdmResponse.setStatus(client.executeMethod((HttpMethod)method));
            mdmResponse.setBody(new String(method.getResponseBody()));
            return mdmResponse;
        }
        catch (GeneralSecurityException e) {
            log.error((Object)"GeneralSecurityException Error occurred while creating an EasySSLProtocolSocketFactory object", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Exception occurred while sending the GET request to " + endpoint), (Throwable)e);
        }
        return null;
    }

    public MDMResponse delete(String endpoint) {
        HttpClient client = new HttpClient();
        try {
            EasySSLProtocolSocketFactory socketFactory = new EasySSLProtocolSocketFactory();
            Protocol https = new Protocol("https", (ProtocolSocketFactory)socketFactory, 9443);
            Protocol.registerProtocol((String)"https", (Protocol)https);
            String url = this.backEndUrl + endpoint;
            DeleteMethod method = new DeleteMethod(url);
            method.setRequestHeader(AUTHORIZATION, this.authrizationString);
            method.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
            MDMResponse mdmResponse = new MDMResponse();
            mdmResponse.setStatus(client.executeMethod((HttpMethod)method));
            mdmResponse.setBody(method.getResponseBodyAsString());
            return mdmResponse;
        }
        catch (GeneralSecurityException e) {
            log.error((Object)"GeneralSecurityException occurred while creating an EasySSLProtocolSocketFactory object.", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Exception occurred while sending the DELETE request to " + endpoint), (Throwable)e);
        }
        return null;
    }
}

