/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.wso2.carbon.automation.test.utils.http.client.HttpRequestUtil;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;

public class RestClient {
    private String backEndUrl;
    private String authrizationString;
    private Map<String, String> requestHeaders = new HashMap<String, String>();
    private static final String AUTHORIZATION = "Authorization";

    public RestClient(String backEndUrl, String contentType) {
        this.backEndUrl = backEndUrl;
        this.requestHeaders.put("Content-Type", contentType);
    }

    public RestClient(String backEndUrl, String contentType, String authorization) {
        this.backEndUrl = backEndUrl;
        this.requestHeaders.put("Content-Type", contentType);
        if (authorization != null || !authorization.isEmpty()) {
            this.authrizationString = authorization;
            this.requestHeaders.put(AUTHORIZATION, authorization);
        }
    }

    public String getAuthrizationString() {
        return this.authrizationString;
    }

    public void setAuthrizationString(String authrizationString) {
        this.authrizationString = authrizationString;
    }

    public void setHttpHeader(String headerName, String value) {
        this.requestHeaders.put(headerName, value);
    }

    public String getHttpHeader(String headerName) {
        return this.requestHeaders.get(headerName);
    }

    public void removeHttpHeader(String headerName) {
        this.requestHeaders.remove(headerName);
    }

    public HttpResponse post(String endpoint, String body) throws Exception {
        return HttpRequestUtil.doPost((URL)new URL(this.backEndUrl + endpoint), (String)body, this.requestHeaders);
    }

    public HttpResponse put(String endpoint, String body) throws Exception {
        HttpURLConnection urlConnection = null;
        try {
            HttpResponse httpResponse;
            urlConnection = (HttpURLConnection)new URL(this.backEndUrl + endpoint).openConnection();
            try {
                urlConnection.setRequestMethod("PUT");
            }
            catch (ProtocolException e) {
                throw new Exception("Shouldn't happen: HttpURLConnection doesn't support POST?? " + e.getMessage(), e);
            }
            urlConnection.setDoOutput(true);
            urlConnection.setDoInput(true);
            urlConnection.setUseCaches(false);
            urlConnection.setAllowUserInteraction(false);
            for (Map.Entry<String, String> sb : this.requestHeaders.entrySet()) {
                urlConnection.setRequestProperty(sb.getKey(), sb.getValue());
            }
            try (OutputStream outputStream = urlConnection.getOutputStream();){
                OutputStreamWriter sb1 = new OutputStreamWriter(outputStream, "UTF-8");
                sb1.write(body);
                sb1.close();
            }
            StringBuilder sb2 = new StringBuilder();
            try (BufferedReader rd = null;){
                String itr;
                rd = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), Charset.defaultCharset()));
                while ((itr = rd.readLine()) != null) {
                    sb2.append(itr);
                }
            }
            Iterator<String> iterator = urlConnection.getHeaderFields().keySet().iterator();
            HashMap<String, String> responseHeaders = new HashMap<String, String>();
            while (iterator.hasNext()) {
                String key = iterator.next();
                if (key == null) continue;
                responseHeaders.put(key, urlConnection.getHeaderField(key));
            }
            HttpResponse httpResponse2 = httpResponse = new HttpResponse(sb2.toString(), urlConnection.getResponseCode(), responseHeaders);
            return httpResponse2;
        }
        catch (IOException e) {
            throw new Exception("Connection error (Is server running at " + endpoint + " ?): " + e.getMessage(), e);
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
    }

    public HttpResponse get(String endpoint) throws Exception {
        return HttpRequestUtil.doGet((String)(this.backEndUrl + endpoint), this.requestHeaders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpResponse delete(String endpoint) throws Exception {
        HttpResponse httpResponse1;
        HttpURLConnection conn = null;
        try {
            HttpResponse httpResponse;
            URL url = new URL(this.backEndUrl + endpoint);
            conn = (HttpURLConnection)url.openConnection();
            conn.setRequestMethod("DELETE");
            conn.setDoOutput(true);
            conn.setReadTimeout(30000);
            for (Map.Entry<String, String> rd : this.requestHeaders.entrySet()) {
                conn.setRequestProperty(rd.getKey(), rd.getValue());
            }
            conn.connect();
            StringBuilder sb1 = new StringBuilder();
            try (BufferedReader rd1 = null;){
                String ignored;
                rd1 = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                while ((ignored = rd1.readLine()) != null) {
                    sb1.append(ignored);
                }
                httpResponse = new HttpResponse(sb1.toString(), conn.getResponseCode());
                httpResponse.setResponseMessage(conn.getResponseMessage());
            }
            httpResponse1 = httpResponse;
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return httpResponse1;
    }
}

