/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.configuration;

import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.mdm.integration.common.AssertUtil;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.TestBase;

public class ConfigurationManagement
extends TestBase {
    private MDMHttpClient client;

    @BeforeClass(alwaysRun=true, groups={"configuration-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPSURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Test save configuration.")
    public void testSaveConfiguration() throws Exception {
        MDMResponse response = this.client.post("/mdm-admin/configuration", PayloadGenerator.getJsonPayload("configuration-payloads.json", "POST").toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("configuration-response-payloads.json", "POST").toString(), response.getBody(), true);
    }

    @Test(description="Test get configuration.", dependsOnMethods={"testSaveConfiguration"})
    public void testGetConfiguration() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/configuration");
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("configuration-response-payloads.json", "GET").toString(), response.getBody(), true);
    }

    @Test(description="Test get configuration with erroneous end point.", dependsOnMethods={"testSaveConfiguration"})
    public void testGetConfigurationWithErroneousEndPoint() throws Exception {
        MDMResponse response = this.client.get("/mdm-admin/configuration/android");
        Assert.assertEquals((int)401, (int)response.getStatus());
        Assert.assertEquals((String)"Scope validation failed", (String)response.getBody());
    }
}

