/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.device.configuration;

import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.carbon.automation.test.utils.http.client.HttpResponse;
import org.wso2.mdm.integration.common.AssertUtil;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.RestClient;
import org.wso2.mdm.integration.common.TestBase;

public class AndroidConfigurationManagement
extends TestBase {
    private RestClient client;

    @BeforeClass(alwaysRun=true, groups={"android-config-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPURL, this.backendHTTPSURL);
        this.client = new RestClient(this.backendHTTPURL, "application/json", accessTokenString);
    }

    @Test(description="Test add android platform configuration.")
    public void testAddConfiguration() throws Exception {
        HttpResponse response = this.client.post("/mdm-android-agent/configuration/", PayloadGenerator.getJsonPayload("android-configuration-payloads.json", "POST").toString());
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-config-response-payloads.json", "POST").toString(), response.getData().toString(), true);
    }

    @Test(description="Test update android configuration.", dependsOnMethods={"testAddConfiguration"})
    public void testModifyConfiguration() throws Exception {
        HttpResponse response = this.client.put("/mdm-android-agent/configuration/", PayloadGenerator.getJsonPayload("android-configuration-payloads.json", "PUT").toString());
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-config-response-payloads.json", "PUT").toString(), response.getData().toString(), true);
    }

    @Test(description="Test get android configuration.", dependsOnMethods={"testAddConfiguration", "testModifyConfiguration"})
    public void testGetConfiguration() throws Exception {
        HttpResponse response = this.client.get("/mdm-android-agent/configuration/");
        Assert.assertEquals((int)200, (int)response.getResponseCode());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-configuration-payloads.json", "PUT").toString(), response.getData().toString(), true);
    }
}

