/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.device.enrollment;

import com.google.gson.JsonObject;
import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.mdm.integration.common.AssertUtil;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.TestBase;

public class AndroidEnrollment
extends TestBase {
    private MDMHttpClient client;

    @BeforeClass(alwaysRun=true, groups={"android-enrollment"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(description="Test an Android device enrollment.")
    public void testEnrollment() throws Exception {
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload("android-enrollment-payloads.json", "POST");
        enrollmentData.addProperty("deviceIdentifier", "1234");
        MDMResponse response = this.client.post("/mdm-android-agent/enrollment/", enrollmentData.toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-enrollment-response-payloads.json", "POST").toString(), response.getBody(), true);
    }

    @Test(description="Test an Android device enrollment with no device identifier")
    public void testEnrollmentWithErroneousInfo() throws Exception {
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload("android-enrollment-erroneous-payloads.json", "POST");
        enrollmentData.addProperty("deviceIdentifier", "1234");
        MDMResponse response = this.client.post("/mdm-android-agent/enrollment/", enrollmentData.toString());
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    @Test(description="Test an Android device is enrolled.", dependsOnMethods={"testEnrollment"})
    public void testIsEnrolled() throws Exception {
        MDMResponse response = this.client.get("/mdm-android-agent/enrollment/1234");
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-enrollment-response-payloads.json", "GET").toString(), response.getBody(), true);
    }

    @Test(description="Test modify enrollment.", dependsOnMethods={"testIsEnrolled"})
    public void testModifyEnrollment() throws Exception {
        JsonObject enrollmentData = PayloadGenerator.getJsonPayload("android-enrollment-payloads.json", "PUT");
        enrollmentData.addProperty("deviceIdentifier", "1234");
        MDMResponse response = this.client.put("/mdm-android-agent/enrollment/1234", enrollmentData.toString());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-enrollment-response-payloads.json", "PUT").toString(), response.getBody(), true);
    }

    @Test(description="Test disenrollment.", dependsOnMethods={"testModifyEnrollment"})
    public void testDisEnrollDevice() throws Exception {
        MDMResponse response = this.client.delete("/mdm-android-agent/enrollment/1234");
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-enrollment-response-payloads.json", "DELETE").toString(), response.getBody(), true);
    }

    @Test(description="Test disenrollment with wrong device ID.", dependsOnMethods={"testModifyEnrollment"})
    public void testDisEnrollDeviceWithWrongDeviceId() throws Exception {
        MDMResponse response = this.client.delete("/mdm-android-agent/enrollment/1111");
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-enrollment-erroneous-response-payloads.json", "DELETE").toString(), response.getBody(), true);
    }

    @Test(description="Test disenrollment for already disenrolled device.", dependsOnMethods={"testDisEnrollDevice"})
    public void testDisEnrollDeviceSameDeviceTwice() throws Exception {
        MDMResponse response = this.client.delete("/mdm-android-agent/enrollment/1234");
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-enrollment-erroneous-response-payloads.json", "DELETE").toString(), response.getBody(), true);
    }
}

