/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.device.enrollment;

import java.io.File;
import java.net.URL;
import junit.framework.Assert;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ObjectNode;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.mdm.integration.common.Constants;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.TestBase;

public class WindowsEnrollment
extends TestBase {
    private MDMHttpClient client;
    private static String bsd;
    private static String UserToken;
    private static final String BSD_PLACEHOLDER = "{BinarySecurityToken}";
    Base64 base64Encoder;

    @BeforeClass(alwaysRun=true, groups={"windows-enrollment"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPSURL, "application/json", accessTokenString);
    }

    @Test(groups={"windows-enrollment"}, description="Test Windows Discovery get.")
    public void testServerAvailability() throws Exception {
        this.client.setHttpHeader("Content-Type", "application/soap+xml; charset=utf-8");
        MDMResponse response = this.client.get("/mdm-windows-agent/services/discovery/get");
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(groups={"windows-enrollment"}, description="Test Windows Discovery post.", dependsOnMethods={"testServerAvailability"})
    public void testDiscoveryPost() throws Exception {
        String xml = this.readXML(Constants.WindowsEnrollment.DISCOVERY_POST_FILE, "UTF-8");
        this.client.setHttpHeader("Content-Type", "application/soap+xml; charset=utf-8");
        MDMResponse response = this.client.post("/mdm-windows-agent/services/discovery/post", xml);
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(groups={"windows-enrollment"}, description="Test Windows BST.", dependsOnMethods={"testDiscoveryPost"})
    public void testBST() throws Exception {
        String token = "token";
        ObjectMapper mapper = new ObjectMapper();
        JsonNode root = mapper.readTree("{\"credentials\" : {\"username\" : \"admin\", \"email\" : \"admin@wso2.com\", \"password\" : \"admin\", \"ownership\" : \"BYOD\", \"token\" : \"cbe53efd46ec612c456540f8dfef5428\"}}");
        JsonNode node = root.path("credentials");
        ((ObjectNode)node).put(token, OAuthUtil.getOAuthToken(this.backendHTTPURL, this.backendHTTPSURL));
        this.client.setHttpHeader("Content-Type", "application/json");
        MDMResponse response = this.client.post("/mdm-windows-agent/services/federated/bst/authentication", root.toString());
        bsd = response.getBody();
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(groups={"windows-enrollment"}, description="Test Windows MS XCEP post.", dependsOnMethods={"testBST"})
    public void testMSXCEP() throws Exception {
        this.base64Encoder = new Base64();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(bsd);
        JsonNode token = node.get(UserToken);
        String encodedToken = this.base64Encoder.encodeToString(token.getTextValue().getBytes());
        String xml = this.readXML(Constants.WindowsEnrollment.MS_XCEP_FILE, "UTF-8");
        String payload = xml.replace(BSD_PLACEHOLDER, encodedToken);
        this.client.setHttpHeader("Content-Type", "application/soap+xml; charset=utf-8");
        MDMResponse response = this.client.post("/mdm-windows-agent/services/certificatepolicy/xcep", payload);
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    @Test(groups={"windows-enrollment"}, description="Test Windows WSETP post.", dependsOnMethods={"testMSXCEP"})
    public void testWSETP() throws Exception {
        this.base64Encoder = new Base64();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode node = mapper.readTree(bsd);
        JsonNode token = node.get(UserToken);
        String encodedToken = this.base64Encoder.encodeToString(token.getTextValue().getBytes());
        String xml = this.readXML(Constants.WindowsEnrollment.WS_STEP_FILE, "UTF-8");
        String payload = xml.replace(BSD_PLACEHOLDER, encodedToken);
        this.client.setHttpHeader("Content-Type", "application/soap+xml; charset=utf-8");
        MDMResponse response = this.client.post("/mdm-windows-agent/services/deviceenrolment/wstep", payload);
        Assert.assertEquals((int)200, (int)response.getStatus());
    }

    private String readXML(String fileName, String characterEncoding) throws Exception {
        URL url = ClassLoader.getSystemResource(fileName);
        File folder = new File(url.toURI());
        return FileUtils.readFileToString((File)folder, (String)characterEncoding);
    }

    static {
        UserToken = "UserToken";
    }
}

