/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.mdm.integration.device.mgt;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import junit.framework.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.wso2.carbon.automation.engine.context.TestUserMode;
import org.wso2.mdm.integration.common.AssertUtil;
import org.wso2.mdm.integration.common.MDMHttpClient;
import org.wso2.mdm.integration.common.MDMResponse;
import org.wso2.mdm.integration.common.OAuthUtil;
import org.wso2.mdm.integration.common.PayloadGenerator;
import org.wso2.mdm.integration.common.TestBase;

public class AndroidDeviceManagement
extends TestBase {
    private MDMHttpClient client;
    private JsonObject device;

    @BeforeClass(alwaysRun=true, groups={"device-mgt"})
    public void initTest() throws Exception {
        super.init(TestUserMode.SUPER_TENANT_ADMIN);
        String accessTokenString = "Bearer " + OAuthUtil.getOAuthToken(this.backendHTTPURL, this.backendHTTPSURL);
        this.client = new MDMHttpClient(this.backendHTTPURL, "application/json", accessTokenString);
    }

    @Test(description="Test get all android devices.", groups={"device-mgt"})
    public void testGetAllDevices() throws Exception {
        MDMResponse response = this.client.get("/mdm-android-agent/device/");
        JsonArray jsonArray = new JsonParser().parse(response.getBody()).getAsJsonArray();
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((int)jsonArray.size(), (int)1);
    }

    @Test(description="Test get android device.", groups={"device-mgt"})
    public void testGetDevice() throws Exception {
        MDMResponse response = this.client.get("/mdm-android-agent/device/1234");
        this.device = new JsonParser().parse(response.getBody()).getAsJsonObject();
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertEquals((String)this.device.get("deviceIdentifier").getAsString(), (String)"1234");
    }

    @Test(description="Test update android device.", groups={"device-mgt"}, dependsOnMethods={"testGetDevice"})
    public void testUpdateDevice() throws Exception {
        this.device.addProperty("name", "UpdatedName");
        MDMResponse response = this.client.put("/mdm-android-agent/device/1234", this.device.toString());
        Assert.assertEquals((int)200, (int)response.getStatus());
        AssertUtil.jsonPayloadCompare(PayloadGenerator.getJsonPayload("android-device-mgt-response-payloads.json", "PUT").toString(), response.getBody().toString(), true);
    }

    @Test(description="Test update android device with invalid device id.", groups={"device-mgt"}, dependsOnMethods={"testGetDevice"})
    public void testUpdateDeviceWithInvalidDeviceId() throws Exception {
        this.device.addProperty("name", "UpdatedName");
        MDMResponse response = this.client.put("/mdm-android-agent/device/1111", this.device.toString());
        Assert.assertEquals((int)500, (int)response.getStatus());
    }

    @Test(description="Test get android license.", groups={"device-mgt"})
    public void testGetLicense() throws Exception {
        MDMResponse response = this.client.get("/mdm-android-agent/device/license");
        String sequence = "This";
        Assert.assertEquals((int)200, (int)response.getStatus());
        Assert.assertTrue((boolean)response.getBody().contains(sequence));
    }
}

